/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.annotation;

import java.util.Map;
import java.lang.reflect.AnnotatedElement;

/**
 * This interface encapsulates all AnnotatedElements processing result by 
 * the AnnotationProcessor tool. Each AnnotatedElement can have multiple 
 * annotations, therefore the AnnotationProcessor tool result is defined 
 * by the list of AnnotatedElements it processed and for each AnnotatedElement,
 * it defines each Annotation processed and its processing result.
 *
 * @author Jerome Dochez
 */
public interface ProcessingResult {
    
    /**
     * @return a Map indexed by all AnnotatedElements processed and each 
     * AnnotatedElement HandlerProcessingResult as values.
     */
    public Map<AnnotatedElement,HandlerProcessingResult> getResults();
    
    /**
     * @return the overall processing result, which is usually the most 
     * severe ResultType for all the annotated elements processing
     */
    public ResultType getOverallResult();
}
