/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.annotation.context;

import java.util.Stack;
import java.lang.reflect.AnnotatedElement;
import java.lang.annotation.ElementType;

import com.sun.enterprise.deployment.annotation.AnnotatedElementHandler;
import com.sun.enterprise.deployment.annotation.AnnotationProcessorException;
import com.sun.enterprise.deployment.annotation.ProcessingContext;

/**
 * Convenient superclass implementation of Context objects responsible
 * for holding references to the DOL objects
 *
 * @author Jerome Dochez
 */
public class AnnotationContext implements AnnotatedElementHandler {
   
    ProcessingContext processingContext;
    
    /** Creates a new instance of AnnotationContext */
    public AnnotationContext() {
    }
    
    public void setProcessingContext(ProcessingContext processingContext) {
        this.processingContext = processingContext;        
    }
    
    public ProcessingContext getProcessingContext() {
        return processingContext;
    }
    
    public void startElement(ElementType type, AnnotatedElement element) 
        throws AnnotationProcessorException {
    }
   
    public void endElement(ElementType type, AnnotatedElement element)
        throws AnnotationProcessorException {
    }     
    

}
