/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.annotation.impl;

import java.util.logging.Logger;
import java.util.logging.*;
import java.util.ResourceBundle;
import java.text.MessageFormat;

import com.sun.enterprise.deployment.annotation.ErrorHandler;

/**
 * Bag for utility methods
 *
 * @author Jerome Dochez
 */
public class AnnotationUtils {
    
    private static Logger logger;
    private static String whatToLog="";
    private static ResourceBundle resourceBundle;
    
    /** Creates a new instance of AnnotationUtils */
    private AnnotationUtils() {
        resourceBundle = ResourceBundle.getBundle("LocalStrings");
    }
    
    public static Logger getLogger() {
        if (logger==null) {
            logger = Logger.global;
        }
        return logger;        
    }

    public static void setLogger(Logger lg) {
        logger = lg;
    }
    
    public static void setLoggerTarget(String what) {
        whatToLog = what;
    }
    
    public static String getLoggerTarget() {
        return whatToLog;
    }
    
    public static boolean shouldLog(String what) {
        
        if (logger.isLoggable(Level.FINER)) {
            if (whatToLog.indexOf(what)!=-1) 
                return true;
            if ("*".equals(whatToLog))
                return true;
        }
        return false;
    }
    
    public static String getLocalString(String key, String defaultString, Object... arguments){
        String value = defaultString;
        if (resourceBundle!=null && resourceBundle.getString(key)!=null){
            value = resourceBundle.getString(key);
        }
        return MessageFormat.format(value, arguments);
    }
}
