/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.annotation.impl;

import java.util.Stack;
import com.sun.enterprise.deployment.annotation.*;
import com.sun.enterprise.deployment.annotation.context.AnnotationContext;

/**
 * Minimal implementation of the ProcessingContext interface
 *
 * @author Jerome ochez
 */
class ProcessingContextImpl implements ProcessingContext {
    
    protected AnnotationProcessor processor;
    protected Stack<AnnotatedElementHandler> handlers = new Stack<AnnotatedElementHandler>();
    protected Scanner scanner;
    
    /** Creates a new instance of ProcessingContextHelper */
    ProcessingContextImpl(AnnotationProcessor processor) {
        this.processor = processor;
    }
    
    public AnnotationProcessor getProcessor() {
        return processor;
    }
        
    public void pushHandler(AnnotatedElementHandler handler) {
        if (handler instanceof AnnotationContext) {
            ((AnnotationContext) handler).setProcessingContext(this);
        }
        handlers.push(handler);
    }
    
    public AnnotatedElementHandler getHandler() {
        if (handlers.isEmpty()) 
            return null;
        
        return handlers.peek();
    }
    
    public AnnotatedElementHandler popHandler() {
        if (handlers.isEmpty()) 
            return null;
        
        return handlers.pop();
    }
        
    /** 
     * @return the previously set ClientContext casted to the requestd
     * type if possible or throw an exception otherwise.
     */
    public <U extends AnnotatedElementHandler> U getHandler(Class<U> contextType)
        throws ClassCastException {
        
        if (handlers.isEmpty()) 
            return null;
        if (AnnotationUtils.shouldLog("handler")) {
            AnnotationUtils.getLogger().finer("Top handler is " + handlers.peek());
        }
        return contextType.cast(handlers.peek());
    }
    
    public Scanner getProcessingInput() {
        return scanner;
    }
    public void setProcessingInput(Scanner scanner) {
        this.scanner = scanner;
    }

    private ErrorHandler errorHandler = null;
    
    /** 
     * Sets the error handler for this processing context.
     */
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }
    
    /**
     * @return the error handler for this processing context.
     */
    public ErrorHandler getErrorHandler() {
        return errorHandler;
    }      
}
