/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.annotation.impl;

import java.util.Map;
import java.util.HashMap;
import java.lang.reflect.AnnotatedElement;

import com.sun.enterprise.deployment.annotation.ProcessingResult;
import com.sun.enterprise.deployment.annotation.ResultType;
import com.sun.enterprise.deployment.annotation.HandlerProcessingResult;

/**
 * Implementation of the ProcessingResult interface
 *
 * @author Jerome Dochez
 */
public class ProcessingResultImpl implements ProcessingResult {
    
    Map<AnnotatedElement, HandlerProcessingResult> results;
    ResultType overallResult = ResultType.UNPROCESSED;
    
    /** Creates a new instance of ProcessingResultImpl */
    public ProcessingResultImpl() {
        results = new HashMap<AnnotatedElement, HandlerProcessingResult>();
    }
    
    public void add(ProcessingResult pr) {
        
        Map<AnnotatedElement, HandlerProcessingResult> results = pr.getResults();
        for (AnnotatedElement element : results.keySet()) {
            add(element, results.get(element));
        }
    }
    
    public void add(AnnotatedElement element, HandlerProcessingResult elementResult) {

        if (elementResult.getOverallResult().compareTo(overallResult)>0) {
            overallResult = elementResult.getOverallResult();
        }
        if (results.containsKey(element)) {
            HandlerProcessingResultImpl previousResult = (HandlerProcessingResultImpl) results.get(element);
            previousResult.addAll(elementResult);
        } else {
            if (elementResult instanceof HandlerProcessingResultImpl) {
                results.put(element, elementResult);
            } else {
                HandlerProcessingResultImpl result = new HandlerProcessingResultImpl();
                result.addAll(elementResult);
                results.put(element, result);
            }
        }
    }
    
    public Map<AnnotatedElement,HandlerProcessingResult> getResults() {
        return results;
    }
    
    public ResultType getOverallResult(){
        return overallResult;
    }
}
