/*
 * PortCreationListenerImpl.java
 *
 * Created on February 15, 2006, 9:59 AM
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package com.sun.enterprise.jbi.serviceengine.bridge;

import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.webservice.ServiceEngineUtil;
import com.sun.enterprise.webservice.spi.InvInterfaceCreationListener;
import javax.xml.ws.Dispatch;

/**
 *
 * @author mu125243
 */
public class PortCreationListenerImpl implements InvInterfaceCreationListener{
    
    /**
     * DOL for the service.
     */
    private ServiceReferenceDescriptor serviceRef;
    
    /** Creates a new instance of PortCreationListenerImpl */
    public PortCreationListenerImpl(ServiceReferenceDescriptor serviceRef) {
        this.serviceRef = serviceRef;
    }
    
    /**
     * Sets transport factory to NMR if port is jbi-enabled
     * @param port instance
     * @param service endpoint interface type
     */
    public <T> void portCreated(T port, Class<T> serviceEndpointInterface) {
        ServiceEngineUtil.setJBITransportFactory(serviceRef, port, serviceEndpointInterface);
    }
       
    /**
     * Currently this is empty implementation
     * @param dispatch instance
     * @param service endpoint interface type
     */
    public <T> void dispatchCreated(Dispatch<T> dispatch, Class<T> serviceEndpointInterface) {
        // Do nothing
    }
}
