/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 *
 *NMClientTransport.java
 *
 * Created on May 4, 2005, 1:32 PM
 */
package com.sun.enterprise.jbi.serviceengine.bridge.transport;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPPart;
// import javax.xml.rpc.BindingProvider;
// import javax.xml.rpc.JAXRPCContext;

import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.servicedesc.ServiceEndpoint;

import com.sun.xml.rpc.client.ClientTransport;
import com.sun.xml.rpc.soap.message.SOAPMessageContext;

//import com.sun.enterprise.jbi.component.MessageFormatHandler;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.jbi.serviceengine.core.JavaEEServiceEngineContext;
import com.sun.enterprise.jbi.serviceengine.util.soap.MessageExchangeHelper;

/**
 *
 * @author Manisha Umbarje
 */
public class JAXRPCClientTransport implements ClientTransport {
    
    private DeliveryChannel channel;
    //private QName svcQName;
    private ServiceRefPortInfo portInfo;
   
    public JAXRPCClientTransport() {
        channel = JavaEEServiceEngineContext.getInstance().getDeliveryChannel();
    }

    /*public void setServiceQName(QName q) {
	svcQName = q;
    }*/


    public void invoke(String endpoint, SOAPMessageContext soapMsgContext) {

	try {
            
            MessageExchangeHelper meHelper = new MessageExchangeHelper();
            meHelper.initializeMessageExchange(portInfo,false);
            meHelper.normalizeMessage(soapMsgContext.getMessage(), true);
            meHelper.dispatchMessage();
            SOAPMessage responseMessage = meHelper.denormalizeMessage(false);
            soapMsgContext.setMessage(responseMessage);
	}
	catch ( Exception e ) {
	    throw new TransportFailedException(e.getMessage());
	}
	
    }
    
    public void invokeOneWay(String endpoint, SOAPMessageContext context) {
        invoke(endpoint, context);
    }
    
    public void setServicePortInfo(ServiceRefPortInfo portInfo) {
        this.portInfo = portInfo;
    }
}
