/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.jbi.serviceengine.config;
import com.sun.enterprise.jbi.serviceengine.ServiceEngineException;
import com.sun.enterprise.jbi.serviceengine.core.Bridge;

/**
 * Configuration info of Application Server component
 *
 * @author
 * @since SJSAS 9.0
 */ 
public class ComponentConfiguration {

    /**
     * This may be set by administrator to use another 
     * thread pool for the configuration.
     */
    private final String THREADPOOL = 
        "com.sun.enterprise.jbi.config.ThreadPool";

    private String BRIDGE_CLASS="com.sun.enterprise.jbi.serviceengine.bridge.AppServerBridge";
    
    /**
     * Return the thread pool name for the component.
     *
     * @return Name of thread pool, if set by the user.
     *         Returns null, if nothing is set.
     */
    public String getCommonThreadPoolName() {
        return System.getProperty(THREADPOOL);   
    }
    
    public Bridge getBridge() throws ServiceEngineException{
        try {
            return (Bridge)Class.forName(BRIDGE_CLASS).newInstance();
        } catch(Exception e) {
            throw new ServiceEngineException("Error initializing Bridge,cannot continue :" + e);
        }
    }
}
