/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.jbi.serviceengine.core;
import com.sun.enterprise.jbi.serviceengine.ServiceEngineException;
import com.sun.enterprise.jbi.serviceengine.config.ComponentConfiguration;
import com.sun.enterprise.jbi.serviceengine.work.WorkManagerImpl;
import com.sun.logging.LogDomains;
import java.util.Iterator;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import java.util.logging.Logger;
import java.util.logging.Level;

/**
 * Wrapper for a JBI Context object, provides utility methods
 * @author Manisha Umbarje
 */
public class JavaEEServiceEngineContext {
    
    private ComponentContext jbiContext;
    
    private EndpointRegistry endpointRegistry;
    
    private DeliveryChannel seDeliveryChannel;
    
    private WorkManagerImpl workManager;
    
    private ComponentConfiguration config ;
    
    private Bridge bridge;
    
    private static JavaEEServiceEngineContext serviceEngineContext;
    /**
     * Internal handle to the logger instance
     */
    protected static final Logger logger =
        LogDomains.getLogger(LogDomains.SERVER_LOGGER);

            
    /** Creates a new instance of JavaEEServiceEngineContext */
    private JavaEEServiceEngineContext()  {
    }
    
    public static JavaEEServiceEngineContext getInstance() {
        if (serviceEngineContext == null)
            serviceEngineContext = new JavaEEServiceEngineContext();
        return serviceEngineContext;
    }
    
    public void initialize() throws ServiceEngineException {
        endpointRegistry = EndpointRegistry.getInstance();
        config = new ComponentConfiguration();
        workManager = new WorkManagerImpl(config);
        bridge = config.getBridge();
        bridge.initialize();
    }
    /**
     * Returns the context provided by the JBI environment  to the 
     * service engine
     */
    public ComponentContext getJBIContext() {
        return jbiContext;
    }
    
    public DeliveryChannel getDeliveryChannel() {
        return seDeliveryChannel;
    }
    
    public WorkManagerImpl getWorkManager() {
        return workManager;
    }
    
    public Bridge getBridge() {
        return bridge;
    }
    /**
     *
     */
    public void setJBIContext(ComponentContext context)
    throws MessagingException {
        jbiContext = context;
        seDeliveryChannel = jbiContext.getDeliveryChannel();
        debug(Level.FINE, "Delivery Channel is : " + seDeliveryChannel);
    }
    
    /**
     * Gets the ServiceEndpoint Registry
     */
    public EndpointRegistry getRegistry() {
        return endpointRegistry;
    }
    
    /**
     * Activates multiple end points in JBI
     * @param endpoints list of end points to be activated in JBI
     */
    public void activateEndpoints(Iterator endpoints) 
    throws  JBIException {
        if (endpoints != null) {
            while(endpoints.hasNext()) {
                ServiceEndpoint endpoint = (ServiceEndpoint)endpoints.next();
                jbiContext.activateEndpoint(
                        endpoint.getServiceName(), endpoint.getEndpointName());
            }
        }
        
    }
    
    private void debug(Level logLevel, String msgID) {
        logger.log(logLevel, msgID);
    }

}
