/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise;

import java.net.SocketPermission;
import java.util.PropertyPermission;
import com.sun.enterprise.security.CachedPermissionImpl;
import com.sun.enterprise.security.PermissionCache;
import com.sun.enterprise.security.PermissionCacheFactory;

import java.util.*;
// IASRI 4660742 START
import java.util.logging.*;
import com.sun.logging.*;
// IASRI 4660742 END

/**
 * Java 2 security manager that enforces code security.
 * @author Harish Prabandham
 */
public class J2EESecurityManager extends java.rmi.RMISecurityManager {

// IASRI 4660742 START
    private static Logger _logger=null;
    static{
       _logger=LogDomains.getLogger(LogDomains.ROOT_LOGGER);
        }
// IASRI 4660742 END

    private CachedPermissionImpl connectPerm;

    private PermissionCache cache;

    private boolean cacheEnabled = false;

    public J2EESecurityManager() {
    }

/*
   public void checkAccess(ThreadGroup t) {
   Class[] clss = getClassContext();
   for(int i=1; i < clss.length; ++i) {
// IASRI 4660742   System.out.println(clss[i] + " : " + clss[i].getProtectionDomain());
// START OF IASRI 4660742
            _logger.log(Level.FINE,clss[i] + " : " + clss[i].getProtectionDomain());
// END OF IASRI 4660742
   }
   
   System.out.flush();
   
   // JDK 1.1. implementation...
   Class[] clss = getClassContext();
   for(int i=1; i < clss.length; ++i) {
   checkIfInContainer(clss[i]);
   }
   }
   
   // JDK 1.1. implementation...
    private void checkIfInContainer(Class clazz) {
	Class[] parents = clazz.getDeclaredClasses();
	for(int i=0; i < parents.length; ++i) {
	    if(parents[i] == com.sun.ejb.Container.class) 
		throw new SecurityException("Got it....");
	}
    }
*/

   public void checkAccess(ThreadGroup t) {
       super.checkAccess(t);
       checkPermission(new java.lang.RuntimePermission("modifyThreadGroup"));
   }
    
    public void checkPackageAccess(final String pkgname) {
	// Remove this once 1.2.2 SecurityManager/ClassLoader bug is fixed.
	if(!pkgname.startsWith("sun."))
	    super.checkPackageAccess(pkgname);
    }

    public void checkExit(int status) {
        // Verify exit permission
        super.checkExit(status);
    }

    public void checkConnect(String host, int port) {
	if (checkConnectPermission()) {
	    return;
	}
	super.checkConnect(host, port);
    }

    public void checkConnect(String host, int port, Object context) {
	if (checkConnectPermission()) {
	    return;
	}
	super.checkConnect(host, port, context);
    }

    public void checkPropertyAccess(String key) {
	if (checkProperty(key)) {
	    return;
	} 
	super.checkPropertyAccess(key);
    }

    private boolean checkConnectPermission() {
	if (cacheEnabled()) {
	    return connectPerm.checkPermission();
	} 
	return false;
    }

    private boolean checkProperty(String key) {
	if (cacheEnabled()) {
	    return cache.checkPermission(new PropertyPermission(key, "read"));
	} 
	return false;
    }

    public synchronized boolean cacheEnabled() {
	return cacheEnabled;
    }

    public synchronized void enablePermissionCache(PermissionCache c) {
	if (c != null) {
	    cache = c;
	    connectPerm = new CachedPermissionImpl
		(cache, new SocketPermission("*","connect"));
	    cacheEnabled = true;
	}
    }
   
}





