/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ConfigEnvironment.java
 *
 * Created on January 9, 2004, 11:41 AM
 */

package com.sun.enterprise.config.pluggable;

/**
 * ConfigEnvironment is used by ConfigFactory to 
 * create a configContext. 
 *
 * @author  sridatta
 */
public interface ConfigEnvironment {
    
    /**
     * get the root class for this execution
     * cannot be null.
     */
    String getRootClass();
    void setRootClass(String rootClass);
    
    String getUrl();
    void setUrl(String url);
    
    /**
     * Get the handler required for this execution
     * can return null.
     */
    String getHandler();
    void setHandler(String handler);
    
    /**
     * interceptor for the configbean
     * can return null
     */
    ConfigBeanInterceptor getConfigBeanInterceptor();
    void setConfigBeanInterceptor(ConfigBeanInterceptor cbInterceptor);
    
    
    boolean isReadOnly();
    void setReadOnly(boolean readOnly);
    
    boolean isAutoCommitOn();
    void setAutoCommitOn(boolean value);
    
    
    //ConfigFactoryEnvironment:
    
    /**
     * only used by ConfigFactory to decide whether
     * to cache the ConfigContext or not.
     */
    boolean isCachingEnabled();        
    void setCachingEnabled(boolean value);
    
    
    //ConfigBeanEnvironment
    
    /**
     * gets ConfigBeansSettings for this execution
     */
    ConfigBeansSettings getConfigBeansSettings();
    
}
