/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment;

import java.util.logging.*;
import com.sun.logging.*;

import java.util.Map;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.List;
import java.util.LinkedList;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.deployment.util.LogDomains;
import static com.sun.enterprise.deployment.LifecycleCallbackDescriptor.CallbackType;

/**
 * Contains information about 1 ejb interceptor.
 */ 

public class EjbInterceptor extends JndiEnvironmentRefsGroupDescriptor
{
    private static LocalStringManagerImpl localStrings =
	    new LocalStringManagerImpl(EjbInterceptor.class);

    private static final Logger _logger = LogDomains.getLogger(LogDomains.DPL_LOGGER);

    private Set<LifecycleCallbackDescriptor> aroundInvokeDescriptors;
    private String interceptorClassName;

    // true if the AroundInvoke/Callback methods for this 
    // descriptor were defined on the bean class itself (or one of its
    // super-classes).  false if the methods are defined
    // on a separate interceptor class (or one of its super-classes).  
    private boolean fromBeanClass = false;

    public String getInterceptorClassName() {
        return interceptorClassName;
    }

    public void setInterceptorClassName(String className) {
        interceptorClassName = className;
    }

    public Set<LifecycleCallbackDescriptor> getAroundInvokeDescriptors() {
        if (aroundInvokeDescriptors == null) {
            aroundInvokeDescriptors =
                new HashSet<LifecycleCallbackDescriptor>(); 
        }
        return aroundInvokeDescriptors;
    }

    /**
     * Some clients need the AroundInvoke methods for this inheritance
     * hierarchy in the spec-defined "least derived --> most derived" order.
     */
    public List<LifecycleCallbackDescriptor> getOrderedAroundInvokeDescriptors
        (ClassLoader loader) throws Exception {

        return orderDescriptors(getAroundInvokeDescriptors(), loader);

    }

    public void setFromBeanClass(boolean flag) {
        fromBeanClass = flag;
    }

    public boolean getFromBeanClass() {
        return fromBeanClass;
    }

    public void addAroundInvokeDescriptor(LifecycleCallbackDescriptor aroundInvokeDesc) {
        Set<LifecycleCallbackDescriptor> aroundInvokeDescs =
            getAroundInvokeDescriptors();
        boolean found = false;       
        for (LifecycleCallbackDescriptor ai : aroundInvokeDescs) {
            if ((aroundInvokeDesc.getLifecycleCallbackClass() != null) &&
                aroundInvokeDesc.getLifecycleCallbackClass().equals(
                    ai.getLifecycleCallbackClass())) {
                found = true;
            }
        }

        if (!found) {
            aroundInvokeDescs.add(aroundInvokeDesc);
        }
    }

    public void addAroundInvokeDescriptors(
        Set<LifecycleCallbackDescriptor> aroundInvokes) {
        for (LifecycleCallbackDescriptor ai : aroundInvokes) {
            addAroundInvokeDescriptor(ai);
        }
    }

    public boolean hasAroundInvokeDescriptor() {
        return (getAroundInvokeDescriptors().size() > 0);
    }

    /**
     * Some clients need the Callback methods for this inheritance
     * hierarchy in the spec-defined "least derived --> most derived" order.
     */
    public List<LifecycleCallbackDescriptor> getOrderedCallbackDescriptors
        (CallbackType type, ClassLoader loader) throws Exception {

        return orderDescriptors(getCallbackDescriptors(type), loader);
    }

    public void addPostActivateDescriptor(LifecycleCallbackDescriptor lcDesc) {
        addCallbackDescriptor(CallbackType.POST_ACTIVATE, lcDesc);
    }

    public void addPrePassivateDescriptor(LifecycleCallbackDescriptor lcDesc) {
        addCallbackDescriptor(CallbackType.PRE_PASSIVATE, lcDesc);
    }

    /**
     * Order a set of lifecycle method descriptors for a particular
     * inheritance hierarchy with highest precedence assigned to the
     * least derived class. 
     */
    private List<LifecycleCallbackDescriptor> orderDescriptors
        (Set<LifecycleCallbackDescriptor> lcds, ClassLoader loader) 
        throws Exception 
    {

        LinkedList<LifecycleCallbackDescriptor> orderedDescs =
            new LinkedList<LifecycleCallbackDescriptor>();

        Map<String, LifecycleCallbackDescriptor> map =
            new HashMap<String, LifecycleCallbackDescriptor>();

        for(LifecycleCallbackDescriptor next : lcds) {
            map.put(next.getLifecycleCallbackClass(), next);
        }

        Class nextClass = loader.loadClass(getInterceptorClassName());

        while((nextClass != Object.class) && (nextClass != null)) {
            String nextClassName = nextClass.getName();
            if( map.containsKey(nextClassName) ) {
                LifecycleCallbackDescriptor lcd = map.get(nextClassName);
                orderedDescs.addFirst(lcd);
            }

            nextClass = nextClass.getSuperclass();
        }


        return orderedDescs;

    }

    public String toString() {
        return "EjbInterceptor class = " + getInterceptorClassName();
    }
}
