/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment;

import java.lang.reflect.Method;
import java.lang.reflect.Field;
import java.util.Set;

/**
 * InjectionCapable describes a type of J2EE component environment resource
 * that is capable of being injected at runtime.
 *
 * @author Kenneth Saks
 */
public interface InjectionCapable {

    /**
     * True if a particular resource instance is injectable.  All injectable
     * resources are also exposed via their corresponding java:comp/env
     * namespaces, but not all resources in java:comp/env are injectable.
     * A resource is either field injectable or method injectable but never
     * both.
     */
    public boolean isInjectable();
    
    /**
     * @return the set of injection targets for this resource dependency
     */
    public Set<InjectionTarget> getInjectionTargets();
    
    /**
     * Add a new injection target for this dependency
     */
    public void addInjectionTarget(InjectionTarget target);

    /**
     * ComponentEnvName is the name of the corresponding java:comp/env
     * entry for the object that is to be injected.
     */
    public String getComponentEnvName();

    /**
     * This is the class name of the type of resource that is to be injected.
     */
    public String getInjectResourceType();
    public void setInjectResourceType(String resourceType);
    
}
