/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment;

import java.util.*;
/**
 */
public class LocaleEncodingMappingListDescriptor extends Descriptor {
    
    private Set list = null;
        
    /*
     * standard constructor 
     */
    public LocaleEncodingMappingListDescriptor() {
    }

    /*
     * copy constructor 
     */
    public LocaleEncodingMappingListDescriptor(LocaleEncodingMappingListDescriptor other) {
	super(other);
	if (other.list != null) {
	    list = new HashSet();
	    for (Iterator i = other.list.iterator(); i.hasNext();) {
		LocaleEncodingMappingDescriptor lemd = (LocaleEncodingMappingDescriptor)i.next();
		list.add(new LocaleEncodingMappingDescriptor(lemd));
	    }
	} else {
	    list = null;
	}
    }

    public Set getLocaleEncodingMappingSet() {
	if(list == null) {
	    list = new HashSet();
	}
	return list;
    }

    public Enumeration getLocaleEncodingMappings() {
	return (new Vector(this.getLocaleEncodingMappingSet())).elements();
    }

    public void addLocaleEncodingMapping(LocaleEncodingMappingDescriptor desc) {
	getLocaleEncodingMappingSet().add(desc);
    }

    public void removeLocaleEncodingMapping(LocaleEncodingMappingDescriptor desc) {
	getLocaleEncodingMappingSet().remove(desc);
    }

    /**
     * @return a string describing the values I hold
     */
    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("\nProp : ").append(list);
    }
}
