/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment;

/**
 * This descriptor describes a name value pair association 
 *
 * @author Jerome Dochez
 */
public class NameValuePairDescriptor extends Descriptor {
    
    private String value=null;
    
    /**
    * copy constructor.
    */
    public NameValuePairDescriptor(NameValuePairDescriptor other) {
	super(other);
	value = other.value;
    }

    /**
    * standard constructor.
    */
    public NameValuePairDescriptor() {
	super();
    }

    /**
     * set the value
     */
    public void setValue(String value) {
        this.value = value;
    }
    
    /**
     * @return the value
     */
    public String getValue() {
        return value;        
    }
    
    /**
     * @return a string describing the values I hold
     */
    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("\nProp : ").append(getName()).append("->").append(value);
    }

}
