/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment;

    /** I am a pairing between a descriptor and a descriptor that has a JNDI name.
    *@author Danny Coward
    */

public class NamedReferencePair {
    
    // Types of named reference pairs
    public static final int EJB = 1;
    public static final int EJB_REF = 2;
    public static final int RESOURCE_REF = 3;
    public static final int RESOURCE_ENV_REF = 4;

    private Descriptor referant;
    private NamedDescriptor referee;
    private int type;
    
    public static NamedReferencePair createEjbPair
        (EjbDescriptor referant, EjbDescriptor referee) 
    {
        return new NamedReferencePair(referant, referee, EJB);
    }
        
    public static NamedReferencePair createEjbRefPair
        (Descriptor referant, EjbReferenceDescriptor referee)
    {
        return new NamedReferencePair(referant, referee, EJB_REF);
    }

    public static NamedReferencePair createResourceRefPair
        (Descriptor referant, ResourceReferenceDescriptor referee)
    {
        return new NamedReferencePair(referant, referee, RESOURCE_REF);
    }

    public static NamedReferencePair createResourceEnvRefPair
        (Descriptor referant, JmsDestinationReferenceDescriptor referee)
    {
        return new NamedReferencePair(referant, referee, RESOURCE_ENV_REF);
    }
    
    /** Construct a pairing between the given descriptor and the object
    * it has with a jndi name.*/
    protected NamedReferencePair(Descriptor referant, NamedDescriptor referee, 
                                 int type) {
	this.referant = referant;
	this.referee  = referee;
        this.type     = type;
    }

    /** Gets the descriptor with the named descriptor. */
    public Descriptor getReferant() {
	return this.referant;
    }
    
    /** Gets the named descriptor for the decriptor.*/
    public NamedDescriptor getReferee() {
	return this.referee;
    }

    public String getPairTypeName() {
        switch(this.type) {
            case EJB : return "EJB"; 
            case EJB_REF : return "EJB REF";
            case RESOURCE_REF : return "RESOURCE REF";
            case RESOURCE_ENV_REF : return "RESOURCE ENV REF";
        }
        throw new IllegalStateException("unknown type = " + type);        
    }

    public int getPairType() {
        return this.type;
    }

    /** My pretty format. */
    public void print(StringBuffer toStringBuffer) {
	toStringBuffer.append("NRP: ").append(referant.getName()).append(" -> ").append(((Descriptor) referee).getName());
    }
    
}
