/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment;

import java.util.*;
import java.lang.reflect.*;
import com.sun.enterprise.util.LocalStringManagerImpl;


/** 
 * This class contains information about relationships between
 * EJB2.0 CMP EntityBeans.
 * It represents information in the <ejb-relation> XML element.
 *
 * @author Sanjeev Krishnan
 */

public final class RelationshipDescriptor extends Descriptor {

    private static LocalStringManagerImpl localStrings =
	    new LocalStringManagerImpl(RelationshipDescriptor.class);

    private RelationRoleDescriptor source;  // descriptor for source role
    private RelationRoleDescriptor sink; // descriptor for sink role

    private boolean isBidirectional = true;
    
    public RelationshipDescriptor() {
    }

    public boolean isOneOne() {
	return (!source.getIsMany() && !sink.getIsMany()); 
    }
    
    public boolean isOneMany() {
	return (!source.getIsMany() && sink.getIsMany()); 
    }
    
    public boolean isManyOne() {
	return (source.getIsMany() && !sink.getIsMany()); 
    }
    
    public boolean isManyMany() {
	return (source.getIsMany() && sink.getIsMany()); 
    }

    /**
     * Checks whether an EjbCMPEntityDescriptor
     * is a participant in this relationship.
     */
    public boolean hasParticipant(Descriptor desc) {
        return ( (source.getOwner() == desc) || (sink.getOwner() == desc) );
    }

    public RelationRoleDescriptor getSource()
    {  
	return source;  
    }
    public void setSource(RelationRoleDescriptor source)
    {  
	this.source = source;  
    }

    public void setSink(RelationRoleDescriptor sink)
    {
	this.sink = sink;
    }
    public RelationRoleDescriptor getSink()
    {
	return sink;
    }

    public void setIsBidirectional(boolean isBidirectional)
    {
	this.isBidirectional = isBidirectional;
    }
    public boolean getIsBidirectional()
    {
	return isBidirectional;
    }

    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("From EJB ").append(getSource().getName()
           ).append(" cmr field : ").append(getSource().getCMRField()
           ).append("(").append(getSource().getCMRFieldType()).append(")  to EJB ").append(getSink().getName()
           ).append(" isMany ").append(getSource().getIsMany()
           ).append(" cascade-delete ").append(getSource().getCascadeDelete());
    }
}
