/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.annotation.context;

import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;

import java.util.Iterator;
import java.util.Set;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.deployment.annotation.ProcessingContext;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.types.EjbReferenceContainer;
import com.sun.enterprise.deployment.types.MessageDestinationReferenceContainer;
import com.sun.enterprise.deployment.types.ResourceReferenceContainer;
import com.sun.enterprise.deployment.types.ServiceReferenceContainer;
import com.sun.enterprise.deployment.types.HandlerChainContainer;

/**
 * This provides an abstraction for handle resource references.
 *
 * @Author Shing Wai Chan
 */
public class ResourceContainerContextImpl extends AnnotationContext
        implements ResourceContainerContext, ComponentContext, 
                   ServiceReferenceContainerContext, HandlerContext {

    protected Descriptor descriptor = null;
    protected String componentClassName = null;

    public ResourceContainerContextImpl() { 
    } 

    public ResourceContainerContextImpl(Descriptor descriptor) { 
        this.descriptor = descriptor;         
    } 
    
    /**
     * Add a reference to an ejb.
     *
     * @param ejbReference the ejb reference
     */
    public void addEjbReferenceDescriptor(EjbReference ejbReference) {
        getEjbReferenceContainer().addEjbReferenceDescriptor(ejbReference);
    }
                                                                               
    /**
     * Looks up an ejb reference with the given name.
     * Return null if it is not found.
     *
     * @param the name of the ejb-reference
     */
    public EjbReference getEjbReference(String name) {
        EjbReference ejbRef = null;
        try {
            ejbRef = getEjbReferenceContainer().getEjbReference(name);
            // annotation has a corresponding ejb-local-ref/ejb-ref
            // in xml.  Just add annotation info and continue.
            // This logic might change depending on overriding rules
            // and order in which annotations are read w.r.t. to xml.
            // E.g. sparse overriding in xml or loading annotations
            // first.  
        } catch(IllegalArgumentException e) {
            // DOL API is (unfortunately) defined to return 
            // IllegalStateException if name doesn't exist.
        }
        return ejbRef;
    }

    protected EjbReferenceContainer getEjbReferenceContainer() {
        return (EjbReferenceContainer)descriptor;
    }

    public void addResourceReferenceDescriptor(ResourceReferenceDescriptor 
                                               resReference) {
        getResourceReferenceContainer().addResourceReferenceDescriptor
            (resReference);
    }
                                                                               
    /**
     * Looks up an resource reference with the given name.
     * Return null if it is not found.
     *
     * @param the name of the resource-reference
     */
    public ResourceReferenceDescriptor getResourceReference(String name) {
        ResourceReferenceDescriptor resourceRef = null;
        try {
            resourceRef = getResourceReferenceContainer().
                getResourceReferenceByName(name);
            // annotation has a corresponding resource-ref
            // in xml.  Just add annotation info and continue.
            // This logic might change depending on overriding rules
            // and order in which annotations are read w.r.t. to xml.
            // E.g. sparse overriding in xml or loading annotations
            // first.  
        } catch(IllegalArgumentException e) {
            // DOL API is (unfortunately) defined to return 
            // IllegalStateException if name doesn't exist.
        }
        return resourceRef;
    }

    protected ResourceReferenceContainer getResourceReferenceContainer() {
        return (ResourceReferenceContainer)descriptor;
    }


    public void addMessageDestinationReferenceDescriptor
        (MessageDestinationReferenceDescriptor msgDestReference) {
        getMessageDestinationReferenceContainer(
        ).addMessageDestinationReferenceDescriptor(msgDestReference);
    }
                                               
                                                                               
    public MessageDestinationReferenceDescriptor getMessageDestinationReference
        (String name) {
        MessageDestinationReferenceDescriptor msgDestRef = null;
        try {
            msgDestRef = getMessageDestinationReferenceContainer().
                getMessageDestinationReferenceByName(name);
            // annotation has a corresponding message-destination-ref
            // in xml.  Just add annotation info and continue.
            // This logic might change depending on overriding rules
            // and order in which annotations are read w.r.t. to xml.
            // E.g. sparse overriding in xml or loading annotations
            // first.  
        } catch(IllegalArgumentException e) {
            // DOL API is (unfortunately) defined to return 
            // IllegalStateException if name doesn't exist.
        }
        return msgDestRef;
    }

    protected MessageDestinationReferenceContainer 
        getMessageDestinationReferenceContainer()
    {
        return (MessageDestinationReferenceContainer)descriptor;
    }

    public void addJmsDestinationReferenceDescriptor
        (JmsDestinationReferenceDescriptor jmsDestReference) {
        getJmsDestinationReferenceContainer(
        ).addJmsDestinationReferenceDescriptor(jmsDestReference);
    }
                                               
    public JmsDestinationReferenceDescriptor getJmsDestinationReference
        (String name) {
        JmsDestinationReferenceDescriptor jmsDestRef = null;
        try {
            jmsDestRef = getJmsDestinationReferenceContainer().
                getJmsDestinationReferenceByName(name);
            // annotation has a corresponding resource-env-ref
            // in xml.  Just add annotation info and continue.
            // This logic might change depending on overriding rules
            // and order in which annotations are read w.r.t. to xml.
            // E.g. sparse overriding in xml or loading annotations
            // first.  
        } catch(IllegalArgumentException e) {
            // DOL API is (unfortunately) defined to return
            // IllegalStateException if name doesn't exist.
        }
        return jmsDestRef;
    }

    protected WritableJndiNameEnvironment 
        getJmsDestinationReferenceContainer()
    {
        return (WritableJndiNameEnvironment)descriptor;
    }

    public void addEnvEntryDescriptor(EnvironmentProperty envEntry) {

        getEnvEntryContainer().addEnvironmentProperty(envEntry);

    }
                                               
    public EnvironmentProperty getEnvEntry(String name) {
        EnvironmentProperty envEntry = null;
        try {
            envEntry = getEnvEntryContainer().
                getEnvironmentPropertyByName(name);
            // annotation has a corresponding env-entry
            // in xml.  Just add annotation info and continue.
            // This logic might change depending on overriding rules
            // and order in which annotations are read w.r.t. to xml.
            // E.g. sparse overriding in xml or loading annotations
            // first.  
        } catch(IllegalArgumentException e) {
            // DOL API is (unfortunately) defined to return 
            // IllegalStateException if name doesn't exist.
        }
        return envEntry;

    }
    
    protected WritableJndiNameEnvironment getEnvEntryContainer()
    {
        return (WritableJndiNameEnvironment)descriptor;
    }

    public void addEntityManagerFactoryReferenceDescriptor
        (EntityManagerFactoryReferenceDescriptor emfRefDesc) {

        getEmfRefContainer().addEntityManagerFactoryReferenceDescriptor
            (emfRefDesc);

    }
                                               
    public EntityManagerFactoryReferenceDescriptor 
        getEntityManagerFactoryReference(String name) {

        EntityManagerFactoryReferenceDescriptor emfRefDesc = null;

        try {
            emfRefDesc = getEmfRefContainer().
                getEntityManagerFactoryReferenceByName(name);
            // annotation has a corresponding entry
            // in xml.  Just add annotation info and continue.
            // This logic might change depending on overriding rules
            // and order in which annotations are read w.r.t. to xml.
            // E.g. sparse overriding in xml or loading annotations
            // first.  
        } catch(IllegalArgumentException e) {
            // DOL API is (unfortunately) defined to return 
            // IllegalStateException if name doesn't exist.
        }

        return emfRefDesc;

    }
    
    protected WritableJndiNameEnvironment getEmfRefContainer()
    {
        return (WritableJndiNameEnvironment)descriptor;
    }


    public void addEntityManagerReferenceDescriptor
        (EntityManagerReferenceDescriptor emRefDesc) {

        getEmRefContainer().addEntityManagerReferenceDescriptor
            (emRefDesc);

    }
                                               
    public EntityManagerReferenceDescriptor 
        getEntityManagerReference(String name) {

        EntityManagerReferenceDescriptor emRefDesc = null;

        try {
            emRefDesc = getEmRefContainer().
                getEntityManagerReferenceByName(name);
            // annotation has a corresponding entry
            // in xml.  Just add annotation info and continue.
            // This logic might change depending on overriding rules
            // and order in which annotations are read w.r.t. to xml.
            // E.g. sparse overriding in xml or loading annotations
            // first.  
        } catch(IllegalArgumentException e) {
            // DOL API is (unfortunately) defined to return 
            // IllegalStateException if name doesn't exist.
        }

        return emRefDesc;

    }
    
    protected WritableJndiNameEnvironment getEmRefContainer()
    {
        return (WritableJndiNameEnvironment)descriptor;
    }

   /**
     * @param postConstructDesc
     */
    public void addPostConstructDescriptor(
            LifecycleCallbackDescriptor postConstructDesc) {
        getPostConstructContainer().addPostConstructDescriptor(postConstructDesc);
    }

    /**
     * Look up an post-construct LifecycleCallbackDescriptor with the
     * given name.  Return null if it is not found
     * @param className
     */
    public LifecycleCallbackDescriptor getPostConstruct(String className) {
        LifecycleCallbackDescriptor postConstructDesc = 
            getPostConstructContainer().getPostConstructDescriptorByClass(className);
        return postConstructDesc;
    }

    protected WritableJndiNameEnvironment getPostConstructContainer() {
        return (WritableJndiNameEnvironment)descriptor;
    }

   /**
     * @param preDestroyDesc
     */
    public void addPreDestroyDescriptor(
            LifecycleCallbackDescriptor preDestroyDesc) {
        getPreDestroyContainer().addPreDestroyDescriptor(preDestroyDesc);
    }

    /**
     * Look up an pre-destroy LifecycleCallbackDescriptor with the
     * given name.  Return null if it is not found
     * @param className
     */
    public LifecycleCallbackDescriptor getPreDestroy(String className) {
        LifecycleCallbackDescriptor preDestroyDesc = 
            getPreDestroyContainer().getPreDestroyDescriptorByClass(className);
        return preDestroyDesc;
    }

    protected WritableJndiNameEnvironment getPreDestroyContainer() {
        return (WritableJndiNameEnvironment)descriptor;
    }

    public String getComponentClassName() {
        return componentClassName;
    }
    
    public HandlerChainContainer[] 
            getHandlerChainContainers(boolean serviceSideHandlerChain, Class declaringClass) {
        // by default return null; appropriate contextx should override this
        return null;
    }
    
    public ServiceReferenceContainer[] getServiceRefContainers() {
        // by default we return our descriptor;
        ServiceReferenceContainer[] containers = new ServiceReferenceContainer[1];
        containers[0] = (ServiceReferenceContainer) descriptor;
        return containers;
    }    
}
