/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.annotation.context;

import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;

import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.annotation.ProcessingContext;

/**
 * This provides a context for a of web component.
 *
 * @author Shing Wai Chan
 */
public class WebComponentContext extends ResourceContainerContextImpl {
    private WebComponentDescriptor webComp = null;

    public WebComponentContext(WebComponentDescriptor wComp) {
        setDescriptor(wComp);
        if (wComp.isServlet()) {
            componentClassName = wComp.getWebComponentImplementation();
        }
    }

    public WebComponentDescriptor getDescriptor() {
        return webComp;
    }

    public void setDescriptor(WebComponentDescriptor webComp) {
        this.webComp = webComp;
        descriptor = webComp.getWebBundleDescriptor();
    }

    public void endElement(ElementType type, AnnotatedElement element) {
        
        if (ElementType.TYPE.equals(type)) {
            // done with processing this class, let's pop this context
            getProcessingContext().popHandler();
        }
    }
}
