/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;

import javax.ejb.ApplicationException;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbApplicationExceptionInfo;

import com.sun.enterprise.deployment.annotation.HandlerProcessingResult;
import com.sun.enterprise.deployment.annotation.AnnotationInfo;
import com.sun.enterprise.deployment.annotation.AnnotatedElementHandler;
import com.sun.enterprise.deployment.annotation.AnnotationProcessorException;
import com.sun.enterprise.deployment.annotation.context.EjbBundleContext;

/**
 * Handles @javax.ejb.ApplicationException 
 */
public class ApplicationExceptionHandler extends AbstractHandler {
    
    public ApplicationExceptionHandler() {
    }
    
    /**
     * @return the annoation type this annotation handler is handling
     */
    public Class<? extends Annotation> getAnnotationType() {
        return ApplicationException.class;
    }    

     public HandlerProcessingResult processAnnotation
         (AnnotationInfo ainfo) throws AnnotationProcessorException {

        AnnotatedElement ae = ainfo.getAnnotatedElement();
        Annotation annotation = ainfo.getAnnotation();

        AnnotatedElementHandler aeHandler = 
            ainfo.getProcessingContext().getHandler();
        

        if (aeHandler instanceof EjbBundleContext) {
            EjbBundleContext ejbBundleContext = (EjbBundleContext)aeHandler;
            
            EjbBundleDescriptor ejbBundle = ejbBundleContext.getDescriptor();

            ApplicationException appExcAnn = (ApplicationException) annotation;

            EjbApplicationExceptionInfo appExcInfo = new 
                EjbApplicationExceptionInfo();
            Class annotatedClass = (Class) ae;
            appExcInfo.setExceptionClassName(annotatedClass.getName());
            appExcInfo.setRollback(appExcAnn.rollback());

            ejbBundle.addApplicationException(appExcInfo);

        }

        return getDefaultProcessedResult();

     }

    protected boolean supportTypeInheritance() {
        return true;
    }
}
