/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.archivist;

import java.io.IOException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.logging.Level;
import javax.enterprise.deploy.shared.ModuleType;

import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.util.DOLUtils;

/**
 * This factory class is responsible for creating Archivists
 *
 * @author  Jerome Dochez
 * @version 
 */
public class ArchivistFactory {
    
    private static PluggableArchivistsHelper defaultArchivists;
    
    /** no need to create ArchivistFactory */
    private ArchivistFactory() {
    }

    
    private static void init() {
        
        if (defaultArchivists!=null)
            return;
        
        // initialize our default Archivists helper singleton 
        // instance.
        defaultArchivists = new PluggableArchivistsHelper();
        defaultArchivists.registerArchivist(new ApplicationArchivist());
        defaultArchivists.registerArchivist(new WebArchivist());
        defaultArchivists.registerArchivist(new ConnectorArchivist());
        defaultArchivists.registerArchivist(new AppClientArchivist());        
        defaultArchivists.registerArchivist(new EjbArchivist());
    }

    public static PluggableArchivists getPluggableArchivists() {
        init();
        return defaultArchivists;
    }
    
    /** 
     * @return a new Archivist implementation for the type passed. 
     * Supported types are defined in the application.xml DTD 
     */
    public static Archivist getArchivistForType(ModuleType type) {
        init();
        return defaultArchivists.getArchivistForType(type);
    }
    
    /** 
     * @return a new Archivist implementation for the archive file type
     * Supported J2EE modules are defined in the J2EE platform spec
     */
    public static Archivist getArchivistForArchive(File jarFileOrDirectory) throws IOException {    
        init();
        return defaultArchivists.getArchivistForArchive(jarFileOrDirectory);
    }        
    
    /** 
     * @return a new Archivist implementation for the archive file type
     * Supported J2EE modules are defined in the J2EE platform spec
     */
    public static Archivist getArchivistForArchive(String path) throws IOException {    
        init();
        return defaultArchivists.getArchivistForArchive(path);
    }
        
    /** 
     * @return a new Archivist implementation for the archive file type
     * Supported J2EE modules are defined in the J2EE platform spec
     */
    public static Archivist getArchivistForArchive(AbstractArchive archive) throws IOException {   
        init();
        return defaultArchivists.getArchivistForArchive(archive);
    }
    
    /**
     * register a new type of archivist
     * @param archivist to register...
     */
    public static void registerArchivist(Archivist archivist) {
        init();
        defaultArchivists.registerArchivist(archivist);
    }
}
