/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.io;

import javax.enterprise.deploy.shared.ModuleType;

/**
 * Repository of descriptors
 * This class will evolve to provide a comprhensive list of
 * descriptors for any given type of j2ee application or
 * stand-alone module.
 *
 * @author Sreenivas Munnangi
 */

public class DescriptorList {

	public final static String [] earList = {
		DescriptorConstants.APPLICATION_DD_ENTRY,
		DescriptorConstants.S1AS_APPLICATION_DD_ENTRY
	};

	public final static String [] ejbList = {
		DescriptorConstants.EJB_DD_ENTRY,
		DescriptorConstants.S1AS_EJB_DD_ENTRY,
		DescriptorConstants.S1AS_CMP_MAPPING_DD_ENTRY,
		DescriptorConstants.EJB_WEBSERVICES_JAR_ENTRY
	};

	public final static String [] warList = {
		DescriptorConstants.WEB_DD_ENTRY,
		DescriptorConstants.S1AS_WEB_DD_ENTRY,
		DescriptorConstants.WEB_WEBSERVICES_JAR_ENTRY,
		DescriptorConstants.JAXRPC_JAR_ENTRY
	};

	public final static String [] rarList = {
		DescriptorConstants.RAR_DD_ENTRY,
		DescriptorConstants.S1AS_RAR_DD_ENTRY
	};

	public final static String [] carList = {
		DescriptorConstants.APP_CLIENT_DD_ENTRY,
		DescriptorConstants.S1AS_APP_CLIENT_DD_ENTRY
	};

	public final static String [] getDescriptorsList (ModuleType moduleType) {
		if (moduleType == null) return null;
		if (moduleType == ModuleType.EAR) {
			return earList;
		} else if (moduleType == ModuleType.EJB) {
			return ejbList;
		} else if (moduleType == ModuleType.WAR) {
			return warList;
		} else if (moduleType == ModuleType.RAR) {
			return rarList;
		} else if (moduleType == ModuleType.CAR) {
			return carList;
		}
		return null;
	}
}
