/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.io;

import java.util.Vector;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.node.RootXMLNode;
import com.sun.enterprise.deployment.node.WebServicesDescriptorNode;

/**
 * This class is responsible for handling the 
 * JSR 109 webservices deployment descriptor
 *
 * @author Kenneth Saks
 */
public class WebServicesDeploymentDescriptorFile extends 
    DeploymentDescriptorFile {

    private String descriptorPath;

    public WebServicesDeploymentDescriptorFile(Descriptor desc) {
        descriptorPath = ( desc instanceof WebBundleDescriptor ) ?
            DescriptorConstants.WEB_WEBSERVICES_JAR_ENTRY : DescriptorConstants.EJB_WEBSERVICES_JAR_ENTRY;
    }
    
    /**
     * @return the location of the DeploymentDescriptor file for a
     * particular type of J2EE Archive
     */
    public String getDeploymentDescriptorPath() {
        return descriptorPath;
    }

    public static Vector getAllDescriptorPaths() {
        Vector allDescPaths = new Vector();
        allDescPaths.add(DescriptorConstants.WEB_WEBSERVICES_JAR_ENTRY);
        allDescPaths.add(DescriptorConstants.EJB_WEBSERVICES_JAR_ENTRY);

        return allDescPaths;
    }

    /**
     * @return a RootXMLNode responsible for handling the deployment
     * descriptors associated with this J2EE module
     *
     * @param the descriptor for which we need the node
     */
    public RootXMLNode getRootXMLNode(Descriptor descriptor) {
        if( descriptor instanceof BundleDescriptor ) {
            return new WebServicesDescriptorNode((BundleDescriptor) descriptor);
        }
        return null;
    }  
}
