/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.Map;
import java.util.Set;

import org.xml.sax.Attributes;
import org.w3c.dom.Node;
import org.w3c.dom.Document;

import java.io.IOException;
import java.io.InputStream;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.JaxrpcMappingDescriptor;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.BundleNode;
import com.sun.enterprise.deployment.node.RootXMLNode;
import com.sun.enterprise.deployment.xml.WebServicesTagNames;
import com.sun.enterprise.deployment.util.DOLUtils;

/**
 * Root node for jaxrpc mapping deployment descriptor
 *
 * @author  Kenneth Saks
 * @version 
 */
public class JaxrpcMappingDescriptorNode extends BundleNode 
    implements RootXMLNode
                                    
{    

    public final static XMLElement ROOT_ELEMENT = 
        new XMLElement(WebServicesTagNames.JAXRPC_MAPPING_FILE_ROOT);

    public final static String SCHEMA_ID = "j2ee_jaxrpc_mapping_1_1.xsd";
    private static List<String> systemIDs = null;

    private static final Set complexElements;
    private JaxrpcMappingDescriptor descriptor=null;
    private String javaPackage=null;
    
    // true if mapping file contains more than just package->namespace mappings.
    private boolean complexMapping=false;

    static {
        complexElements = new HashSet();
        complexElements.add(WebServicesTagNames.JAVA_XML_TYPE_MAPPING);
        complexElements.add(WebServicesTagNames.EXCEPTION_MAPPING);
        complexElements.add(WebServicesTagNames.SERVICE_INTERFACE_MAPPING);
        complexElements.add
            (WebServicesTagNames.SERVICE_ENDPOINT_INTERFACE_MAPPING);
    }

    public JaxrpcMappingDescriptorNode() {
        descriptor = new JaxrpcMappingDescriptor();
    }   

    /**
     * @return the XML tag associated with this XMLNode
     */
    protected XMLElement getXMLRootTag() {
        return ROOT_ELEMENT;
    }

    /**
     * @return the DOCTYPE of the XML file
     */
    public String getDocType() {
        return null;
    }
    
    /**
     * @return the SystemID of the XML file
     */
    public String getSystemID() {
        return SCHEMA_ID;
    }

    /**
     * @return the list of SystemID of the XML schema supported
     */
    public List<String> getSystemIDs() {
        if (systemIDs != null) {
            return systemIDs;
        }

        systemIDs = new ArrayList<String>();
        systemIDs.add(SCHEMA_ID);
        return systemIDs;
    }

        /**
     * @return the complete URL for J2EE schemas
     */
    protected String getSchemaURL() {
       return WebServicesTagNames.IBM_NAMESPACE + "/" + getSystemID();
    }
    
   /**
    * @return the descriptor instance to associate with this XMLNode
    */    
    public Object getDescriptor() {
        return descriptor;
    }     

    public void startElement(XMLElement element, Attributes attributes) {
        if( complexMapping ) {
            // NOTE : we don't call super.startElement in this case because
            // we don't need to process any of the attributes
            return;
        } else if( complexElements.contains(element.getQName()) ) {
            complexMapping = true;
            descriptor.setIsSimpleMapping(false);
            // NOTE : we don't call super.startElement in this case because
            // we don't need to process any of the attributes
        } else {
            super.startElement(element, attributes);
        }
    }
         
    /**
     * receives notiification of the value for a particular tag
     * 
     * @param element the xml element
     * @param value it's associated value
     */
    public void setElementValue(XMLElement element, String value) {   
        if (complexMapping) {
            // We only gather namespace->package mapping. In exhaustive(complex)
            // mapping case, it's enough to just capture the fact that we
            // have complex mapping info.  The actual processing of the elements
            // will be done by mapping file modeler during deployment
            return;
        } else if(WebServicesTagNames.PACKAGE_TYPE.equals(element.getQName())) {
            javaPackage = value;
        } else if(WebServicesTagNames.NAMESPACE_URI.equals(element.getQName())){
            descriptor.addMapping(javaPackage, value);
            javaPackage = null;
        } else {
            super.setElementValue(element, value);
        }
    }    

    /**
     * @return the default spec version level this node complies to
     */
    public String getSpecVersion() {
        return "1.1";
    }

    
}
