/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * DescriptionNode.java
 *
 * Created on August 16, 2002, 2:46 PM
 */

package com.sun.enterprise.deployment.node;

import org.xml.sax.Attributes;
import org.w3c.dom.Node;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.xml.TagNames;

/**
 * This node handles the descriptionType xml fragment
 *
 * @author Jerome Dochez
 */
public class LocalizedInfoNode extends LocalizedNode {
    
    /**
     * we do not create descriptors in this node
     */
     public Object getDescriptor() {
	 return null;
     }
     
    /**
     * notification of the end of XML parsing for this node
     */
    public void postParsing() {
        Object o = getParentNode().getDescriptor();
        if (o instanceof Descriptor) {
            Descriptor descriptor = (Descriptor) o;
            if (getXMLRootTag().getQName().equals(TagNames.DESCRIPTION)) {
                descriptor.setLocalizedDescription(lang, localizedValue);
            } else 
            if (getXMLRootTag().getQName().equals(TagNames.NAME)) {
                descriptor.setLocalizedDisplayName(lang, localizedValue);
            }
        }
    }    
}
