/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.xml.PersistenceTagNames;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;

import java.util.Map;
import java.util.HashMap;

import org.xml.sax.Attributes;

/**
 * This node is responsible for reading details about one <persistence-unit/>
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class PersistenceUnitNode extends DeploymentDescriptorNode {

    /**
     * map of element names to method names in {@link PersistenceUnitDescriptor}
     */
    private Map<String, String> dispatchTable;

    /**
     * This is the default constructor which is also called from other
     * constructors of this class. Inside this constructor, we clear the
     * handlers set up by super classes' constructors because they are
     * not applicable in the context of PersistenceNode because
     * unlike standard Java EE schemas, persistence.xsd does not include
     * javaee_5.xsd for things like description, version etc.
     */
    public PersistenceUnitNode() {
        // clear all the handlers set up by super classes
        // because that sets up a handler for description which we are not
        // interested in.
        if (handlers != null) handlers.clear();
        initDispatchTable();
    }

    @Override public void startElement(
            XMLElement element, Attributes attributes) {
        if (PersistenceTagNames.PROPERTY.equals(element.getQName())) {
            assert(attributes.getLength() == 2);
            assert(attributes.getIndex(PersistenceTagNames.PROPERTY_NAME) !=
                    -1);
            assert(attributes.getIndex(PersistenceTagNames.PROPERTY_VALUE) !=
                    -1);
            PersistenceUnitDescriptor persistenceUnitDescriptor = (PersistenceUnitDescriptor) getDescriptor();
            String propName = attributes.getValue(
                    PersistenceTagNames.PROPERTY_NAME);
            String propValue = attributes.getValue(
                    PersistenceTagNames.PROPERTY_VALUE);
            persistenceUnitDescriptor.addProperty(propName, propValue);
            return;
        }
        super.startElement(element, attributes);
    }

    /**
     * This returns the dispatch table for this node.
     * Please note, unlike Java EE schemas persistence.xsd does not include
     * standard elements or attributes (e.g. version, descriptionGroupRef etc.)
     * from javaee_5.xsd, we don't use super classes' dispatch table.
     * @return map of element names to method names in PersistenceUnitDescriptor
     * @see super#getDispatchTable()
     * @see #initDispatchTable()
     */
    protected Map getDispatchTable() {
        return dispatchTable;
    }

    /**
     * Please note, unlike Java EE schemas persistence.xsd does not include
     * standard elements or attributes (e.g. version, descriptionGroupRef etc.)
     * from javaee_5.xsd, we don't use super classes' dispatch table.
     */
    private void initDispatchTable() {
        assert(dispatchTable == null);

        // we don't do super.getDispatchTable() because we are not
        // interested in any of super classes' disptcah table entries.
        Map<String, String> table = new HashMap<String, String>();

        // the values being put into the map represent method names
        // in PersistenceUnitDescriptor class.
        table.put(PersistenceTagNames.NAME, "setName");
        table.put(PersistenceTagNames.TRANSACTION_TYPE, "setTransactionType");
        table.put(PersistenceTagNames.DESCRIPTION, "setDescription");
        table.put(PersistenceTagNames.PROVIDER, "setProvider");
        table.put(PersistenceTagNames.JTA_DATA_SOURCE, "setJtaDataSource");
        table.put(PersistenceTagNames.NON_JTA_DATA_SOURCE,
                "setNonJtaDataSource");
        table.put(PersistenceTagNames.MAPPING_FILE, "addMappingFile");
        table.put(PersistenceTagNames.JAR_FILE, "addJarFile");
        table.put(PersistenceTagNames.EXCLUDE_UNLISTED_CLASSES, "setExcludeUnlistedClasses");
        table.put(PersistenceTagNames.CLASS, "addClass");
        this.dispatchTable = table;
    }

}
