/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * PropertiesNode.java
 *
 * Created on March 24, 2003, 12:39 PM
 */

package com.sun.enterprise.deployment.node;

import java.util.Properties;
import java.util.Enumeration;
import org.w3c.dom.Node;
import com.sun.enterprise.deployment.xml.TagNames;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;

/**
 * This node is responsible for handling property (name, value) 
 * DTD elements to java.util.Properties mapping
 *
 * @author  Jerome Dochez
 */
public class PropertiesNode extends DeploymentDescriptorNode {
    
    private String name=null;
    private Properties descriptor= new Properties();
   
   /**
    * @return the descriptor instance to associate with this XMLNode
    */      
    public Object getDescriptor() {
        return descriptor;
    }
 
    /**
     * receives notification of the value for a particular tag
     * 
     * @param element the xml element
     * @param value it's associated value
     */
    public void setElementValue(XMLElement element, String value) {
        if (TagNames.NAME_VALUE_PAIR_NAME.equals(element.getQName())) {
            name = value;
        } else if (TagNames.NAME_VALUE_PAIR_VALUE.equals(element.getQName())) {
            descriptor.put(name, value);
        }
    }
    
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node in the DOM tree 
     * @param node name for the root element of this xml fragment      
     * @param the descriptor to write
     * @return the DOM tree top node
     */
    public Node writeDescriptor(Node parent, String nodeName, Properties descriptor) {
        
        Node propertiesNode = super.appendChild(parent, nodeName);
        for (Enumeration keys = descriptor.propertyNames(); keys.hasMoreElements();) {  
            Node aProperty = this.appendChild(propertiesNode, RuntimeTagNames.PROPERTY);
            String key = (String) keys.nextElement();
            appendTextChild(aProperty, TagNames.NAME_VALUE_PAIR_NAME, key);
            appendTextChild(aProperty, TagNames.NAME_VALUE_PAIR_VALUE, 
                        descriptor.getProperty(key));        
        }
        return propertiesNode;
    }
}
