/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node;

/**
 *Provides the appropriate implementation depending on the current
 *runtime environment.
 *
 * @author tjquinn
 */
public class SaxParserHandlerFactory {
    
    /** Creates a new instance of SaxParserHandlerFactory */
    public SaxParserHandlerFactory() {
    }
    
    public static SaxParserHandler newInstance() {
        SaxParserHandler result = null;
        
        /*
         *If the property com.sun.aas.installRoot is defined, use the 
         *original implementation (SaxParserHandler) which fetches DTDs and
         *schemas from the installation directory tree.  Otherwise, assume that 
         *the app client container is running under Java Web Start. In that
         *case, there is no product installation directory (at least none can
         *be assumed).  The DTDs and schemas will be retrieved from the
         *JWS-specific jar file instead (SaxParserHandlerBundled).
         */
        if (System.getProperty("com.sun.aas.installRoot") == null) {
            result = new SaxParserHandlerBundled();
        } else {
            result = new SaxParserHandler();
        }
        return result;
    }
}
