/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.node.ejb;

import java.util.Map;
import org.w3c.dom.Node;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.LocalizedInfoNode;
import com.sun.enterprise.deployment.node.MethodNode;
import com.sun.enterprise.deployment.node.DescriptorFactory;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbInitInfo;
import com.sun.enterprise.deployment.MethodDescriptor;

import com.sun.enterprise.deployment.xml.EjbTagNames;

public class EjbInitNode extends DeploymentDescriptorNode {

    public EjbInitNode() {
       super();

       registerElementHandler(new XMLElement(EjbTagNames.INIT_CREATE_METHOD), MethodNode.class, "setCreateMethod");       
       registerElementHandler(new XMLElement(EjbTagNames.INIT_BEAN_METHOD), MethodNode.class, "setBeanMethod");       


    }
        
    /**
     * all sub-implementation of this class can use a dispatch table to map xml element to
     * method name on the descriptor class for setting the element value. 
     *  
     * @return the map with the element name as a key, the setter method as a value
     */    
    protected Map getDispatchTable() {
        // no need to be synchronized for now
        Map table = super.getDispatchTable();
        return table;
    }    

   /**
     * write the relationships descriptor class to a DOM tree and return it
     *
     * @param parent node in the DOM tree 
     * @param node name for the root element of this xml fragment      
     * @param the descriptor to write
     * @return the DOM tree top node
     */
    public Node writeDescriptor(Node parent, String nodeName, EjbInitInfo initMethod) {
        Node initNode = appendChild(parent, nodeName);        
        MethodNode methodNode = new MethodNode();

        methodNode.writeJavaMethodDescriptor
            (initNode, EjbTagNames.INIT_CREATE_METHOD, 
             initMethod.getCreateMethod());

        methodNode.writeJavaMethodDescriptor
            (initNode, EjbTagNames.INIT_BEAN_METHOD,
             initMethod.getBeanMethod());

        return initNode;
    }
}
