/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.node.runtime;

import java.util.Vector;
import java.util.Iterator;
import org.w3c.dom.Node;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.runtime.IASPersistenceManagerDescriptor;
import com.sun.enterprise.deployment.runtime.PersistenceManagerInUse;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;

/**
 * This node handles the pm-descriptors runtime xml element
 *
 * @author  Jerome Dochez
 * @version 
 */

public class PMDescriptorsNode extends RuntimeDescriptorNode {

    /** Creates new CmpNode */
    public PMDescriptorsNode() {
        registerElementHandler(new XMLElement(RuntimeTagNames.PM_DESCRIPTOR), 
                               PMDescriptorNode.class, "addPersistenceManager");
        registerElementHandler(new XMLElement(RuntimeTagNames.PM_INUSE), 
                               PMInUseNode.class, "setPersistenceManagerInUse");        
    }
	
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param node name 
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, String nodeName, EjbBundleDescriptor descriptor) {
		
	Node pms = null;
	Vector pmDescriptors = descriptor.getPersistenceManagers();
	if (pmDescriptors!=null && !pmDescriptors.isEmpty()) {
            pms = super.writeDescriptor(parent, nodeName, descriptor);
            PMDescriptorNode pmNode = new PMDescriptorNode();
            
            for (Iterator pmIterator = pmDescriptors.iterator();pmIterator.hasNext();) {
                IASPersistenceManagerDescriptor pmDescriptor = (IASPersistenceManagerDescriptor) pmIterator.next();
                pmNode.writeDescriptor(pms, RuntimeTagNames.PM_DESCRIPTOR, pmDescriptor);
            }
            PersistenceManagerInUse inUse = descriptor.getPersistenceManagerInUse();
            if (inUse!=null) {
		PMInUseNode inUseNode = new PMInUseNode();
		inUseNode.writeDescriptor(pms, RuntimeTagNames.PM_INUSE, inUse);
            }
        }
	return pms;
    }
}
