/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.runtime;

import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.Node;
import org.w3c.dom.Document;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.types.EjbReferenceContainer;
import com.sun.enterprise.deployment.types.ResourceReferenceContainer;
import com.sun.enterprise.deployment.types.ResourceEnvReferenceContainer;
import com.sun.enterprise.deployment.types.MessageDestinationReferenceContainer;
import com.sun.enterprise.deployment.runtime.RuntimeDescriptor;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.node.runtime.RuntimeDescriptorFactory;

/**
 * Superclass for all the runtime descriptor nodes
 *
 * @author  Jerome Dochez
 * @version 
 */
public class RuntimeDescriptorNode extends DeploymentDescriptorNode 
{
   /**
    * @return the descriptor instance to associate with this XMLNode
    */    
    public Object getDescriptor() {
        
        if (abstractDescriptor==null) {
	    abstractDescriptor = RuntimeDescriptorFactory.getDescriptor(getXMLPath());
            if (abstractDescriptor ==null) {
                return getParentNode().getDescriptor();
            }
        }
        return abstractDescriptor;
    }     
    
    /**
     * receives notification of the value for a particular tag
     * 
     * @param element the xml element
     * @param value it's associated value
     */
    public void setElementValue(XMLElement element, String value) {
	if (getDispatchTable().containsKey(element.getQName())) {
	    super.setElementValue(element, value);
	} else {
	    Object o = getDescriptor();
	    if (o instanceof RuntimeDescriptor) {
		RuntimeDescriptor rd = (RuntimeDescriptor) o;
		rd.setValue(element.getQName(), value);
	    } else {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.addDescriptorFailure",
                    new Object[]{element.getQName() , value });
            }
	}
    }
    
    /**
     * writes all information common to all J2EE components
     *
     * @param xml node parent to add the info to
     * @param the descriptor
     */    
    public static void writeCommonComponentInfo(Node parent, Descriptor descriptor) {
        if (descriptor instanceof EjbReferenceContainer) {
            EjbRefNode.writeEjbReferences(parent, (EjbReferenceContainer) descriptor);
        }	
        if (descriptor instanceof ResourceReferenceContainer) {
            ResourceRefNode.writeResourceReferences(parent, (ResourceReferenceContainer) descriptor);
        }
        if (descriptor instanceof ResourceEnvReferenceContainer) {
            ResourceEnvRefNode.writeResoureEnvReferences(parent, (ResourceEnvReferenceContainer) descriptor);
        }
        if( descriptor instanceof JndiNameEnvironment ) {
            ServiceRefNode.writeServiceReferences
                (parent, (JndiNameEnvironment) descriptor);
        }
        if (descriptor instanceof MessageDestinationReferenceContainer) {
            MessageDestinationRefNode.writeMessageDestinationReferences(parent, 
                (MessageDestinationReferenceContainer) descriptor);
        }
    }                

    public static void writeMessageDestinationInfo(Node parent, 
                                               BundleDescriptor descriptor) {
        for(Iterator iter = descriptor.getMessageDestinations().iterator();
            iter.hasNext();) {
            MessageDestinationRuntimeNode node = 
                new MessageDestinationRuntimeNode();
            node.writeDescriptor(parent, RuntimeTagNames.MESSAGE_DESTINATION,
                                 (MessageDestinationDescriptor) iter.next());
        }
    }

}
