/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.runtime.common;

import com.sun.enterprise.deployment.node.runtime.RuntimeDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.runtime.common.PrincipalNameDescriptor;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * This node handles principal-name information
 *
 * @author deployment dev team
 */
public class PrincipalNameNode  extends RuntimeDescriptorNode {

    /**
     * receives notiification of the value for a particular tag
     *                                               
     * @param element the xml element                
     * @param value it's associated value
     */    
    public void setElementValue(XMLElement element, String value) {   
        PrincipalNameDescriptor principal = 
                (PrincipalNameDescriptor) getDescriptor();
        if (RuntimeTagNames.PRINCIPAL_NAME.equals(element.getQName())) {
            principal.setName(value);
        } else super.setElementValue(element, value);
    }

    /**
     * parsed an attribute of an element
     *  
     * @param the element name
     * @param the attribute name
     * @param the attribute value
     * @return true if the attribute was processed
     */ 
    protected boolean setAttributeValue(
            XMLElement element, XMLElement attribute, String value) {

        PrincipalNameDescriptor principal = 
                            (PrincipalNameDescriptor) getDescriptor();
        if (attribute.getQName().equals(RuntimeTagNames.CLASS_NAME)) {
            principal.setClassName(value);
            return true;
        }
        return false;
    }

    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param node name for 
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(
            Node parent, String nodeName, PrincipalNameDescriptor descriptor) {

        //principal-name
        Element principal = (Element) appendTextChild(
                parent, RuntimeTagNames.PRINCIPAL_NAME, descriptor.getName());

        // class-name
        setAttribute(principal, RuntimeTagNames.CLASS_NAME, descriptor.getClassName());

        return principal;
    }
}
