/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.runtime.web;

import org.w3c.dom.Node;
import org.w3c.dom.Element;

import com.sun.enterprise.deployment.runtime.web.WebProperty;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.runtime.RuntimeDescriptor;


/**
* node for web property tag
*
* @author Jerome Dochez
*/
public class WebPropertyNode extends WebRuntimeNode {

    /**
     * parsed an attribute of an element
     *
     * @param the element name
     * @param the attribute name
     * @param the attribute value
     * @return true if the attribute was processed
     */
    protected boolean setAttributeValue(XMLElement elementName, XMLElement attributeName, String value) {
        RuntimeDescriptor descriptor = 
            (RuntimeDescriptor) getRuntimeDescriptor();
        if (descriptor==null) {
            throw new RuntimeException(
            "Trying to set values on a null descriptor");
        }
        if (attributeName.getQName().equals(RuntimeTagNames.NAME)) {
            descriptor.setAttributeValue(WebProperty.NAME, value);
            return true;
        } else if (attributeName.getQName().equals(RuntimeTagNames.VALUE)) {
            descriptor.setAttributeValue(WebProperty.VALUE, value);
            return true;
        }
        return false;
    }
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param node name for the descriptor
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, String nodeName, 
        WebProperty property) {
        Element propertyElement = 
            (Element) super.writeDescriptor(parent, nodeName, property);

        // description?
        appendTextChild(propertyElement, RuntimeTagNames.DESCRIPTION, property.getDescription());

	setAttribute(propertyElement, RuntimeTagNames.NAME, (String) property.getAttributeValue(WebProperty.NAME));
	setAttribute(propertyElement, RuntimeTagNames.VALUE, (String) property.getAttributeValue(WebProperty.VALUE));
        return propertyElement;
    }
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param node name for the descriptor
     * @param the array of descriptors to write
     */    
    public void writeDescriptor(Node parent, String nodeName, WebProperty[] properties) {
	if (properties==null) 
	    return;
	for (int i=0;i<properties.length;i++) {
	    writeDescriptor(parent, nodeName, properties[i]);
	}
    }
}

