/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * FilterMappingNode.java
 *
 * Created on February 26, 2002, 9:21 PM
 */

package com.sun.enterprise.deployment.node.web;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

import com.sun.enterprise.deployment.ServletFilterMappingDescriptor;
import com.sun.enterprise.deployment.xml.WebTagNames;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.util.web.URLPattern;
import com.sun.enterprise.util.LocalStringManagerImpl;


/**
 * This node handles all information relative to servlet-mapping xml tag
 *
 * @author  Jerome Dochez
 * @version 
 */
public class FilterMappingNode extends DeploymentDescriptorNode {

    private ServletFilterMappingDescriptor descriptor;
    private static LocalStringManagerImpl localStrings =
            new LocalStringManagerImpl(ServletMappingNode.class);
    
   /**
    * @return the descriptor instance to associate with this XMLNode
    */       
    public Object getDescriptor() {
        
       if (descriptor==null) {
            descriptor = (ServletFilterMappingDescriptor) super.getDescriptor();
        }
        return descriptor;
    }    
    
    /**
     * all sub-implementation of this class can use a dispatch table to map xml element to
     * method name on the descriptor class for setting the element value. 
     *  
     * @return the map with the element name as a key, the setter method as a value
     */    
    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put(WebTagNames.FILTER_NAME, "setName");
        return table;
    }    
    
    /**
     * receives notiification of the value for a particular tag
     * 
     * @param element the xml element
     * @param value it's associated value
     */    
    public void setElementValue(XMLElement element, String value) {
        if (WebTagNames.SERVLET_NAME.equals(element.getQName())) {
            descriptor.addServletName(value);
        } else if (WebTagNames.URL_PATTERN.equals(element.getQName())) {
            // If URL Pattern does not start with "/" then
            // prepend it (for Servlet2.2 Web apps)
            Object parent = getParentNode().getDescriptor();
            if (parent instanceof WebBundleDescriptor &&
                ((WebBundleDescriptor) parent).getSpecVersion().equals("2.2"))
            {
                if(!value.startsWith("/") && !value.startsWith("*.")) {
                    value = "/" + value;
                }
            }

            if (!URLPattern.isValid(value)) {
                throw new IllegalArgumentException(localStrings.getLocalString(
                "enterprise.deployment.invalidurlpattern",
                "Invalid URL Pattern: [{0}]",
                new Object[] {value}));
            }
            descriptor.addURLPattern(value);
        } else if (WebTagNames.DISPATCHER.equals(element.getQName())) {
            descriptor.addDispatcher(value);
        } else super.setElementValue(element, value);
    }   
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node in the DOM tree 
     * @param node name for the root element of this xml fragment      
     * @param the descriptor to write
     * @return the DOM tree top node
     */
    public Node writeDescriptor(Node parent, String nodeName, ServletFilterMappingDescriptor descriptor) {
        Node myNode = appendChild(parent, nodeName);
        appendTextChild(myNode, WebTagNames.FILTER_NAME, descriptor.getName());                        
        for (String servletName : descriptor.getServletNames()) {
            appendTextChild(myNode, WebTagNames.SERVLET_NAME, servletName);
        }

        for (String urlPattern : descriptor.getURLPatterns()) {
            appendTextChild(myNode, WebTagNames.URL_PATTERN, urlPattern);
        }

        Set dispatchers = descriptor.getDispatchers();
        for (Iterator i = dispatchers.iterator(); i.hasNext();) {
            String dispatcher = (String) i.next();
            appendTextChild(myNode, WebTagNames.DISPATCHER, dispatcher);
        }
        return myNode;
    }
}
