/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.web;

import java.util.Map;
import java.util.Vector;
import java.util.Enumeration;
import org.w3c.dom.Node;

import com.sun.enterprise.deployment.ServletFilterDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;

import com.sun.enterprise.deployment.node.DisplayableComponentNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.xml.WebTagNames;

/**
 * This class is responsible for handling filter xml node
 *
 * @author  Jerome Dochez
 * @version 
 */
public class FilterNode extends DisplayableComponentNode {

    // constructor. register sub nodes.
    public FilterNode() {
        super();        
        registerElementHandler(new XMLElement(WebTagNames.INIT_PARAM), 
                                                            InitParamNode.class, "addInitializationParameter");            
    }
    
    /**
     * all sub-implementation of this class can use a dispatch table to map xml element to
     * method name on the descriptor class for setting the element value. 
     *  
     * @return the map with the element name as a key, the setter method as a value
     */    
    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put(WebTagNames.NAME, "setDisplayName");
        table.put(WebTagNames.FILTER_NAME, "setName");
        table.put(WebTagNames.FILTER_CLASS, "setClassName");
        return table;
    }
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node in the DOM tree 
     * @param node name for the root element of this xml fragment      
     * @param the descriptor to write
     * @return the DOM tree top node
     */
    public Node writeDescriptor(Node parent, String nodeName, ServletFilterDescriptor descriptor) {       
        Node myNode = appendChild(parent, nodeName);
        writeDisplayableComponentInfo(myNode, descriptor);
        appendTextChild(myNode, WebTagNames.FILTER_NAME, descriptor.getName());         
        appendTextChild(myNode, WebTagNames.FILTER_CLASS, descriptor.getClassName());     
        Vector initParams = descriptor.getInitializationParameters();
        if (!initParams.isEmpty()) {
            WebBundleNode.addInitParam(myNode, WebTagNames.INIT_PARAM, initParams.elements());
        }
        
        return myNode;
    }       
}
