/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.web;

import java.util.Map;
import java.util.Enumeration;
import org.w3c.dom.Node;

import com.sun.enterprise.deployment.JspGroupDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.LocalizedInfoNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.xml.TagNames;
import com.sun.enterprise.deployment.xml.WebTagNames;

/**
 * This node is responsible for handling jsp-group xml tag
 * @version 
 */
public class JspGroupNode  extends DeploymentDescriptorNode {

    public JspGroupNode() {
        super();
        registerElementHandler(new XMLElement(WebTagNames.NAME), LocalizedInfoNode.class);   
    }
    
    /**
     * all sub-implementation of this class can use a dispatch table to map 
     * xml element to
     * method name on the descriptor class for setting the element value. 
     *  
     * @return the map with the element name as a key, the setter method as a 
     * value
     */    
    protected Map getDispatchTable() {    
        Map table = super.getDispatchTable();
        table.put(WebTagNames.URL_PATTERN, "addUrlPattern");
        table.put(TagNames.NAME, "setDisplayName");
        table.put(WebTagNames.EL_IGNORED, "setElIgnored");
        table.put(WebTagNames.PAGE_ENCODING, "setPageEncoding");
        table.put(WebTagNames.SCRIPTING_INVALID, "setScriptingInvalid");
        table.put(WebTagNames.INCLUDE_PRELUDE, "addIncludePrelude");
        table.put(WebTagNames.INCLUDE_CODA, "addIncludeCoda");
        table.put(WebTagNames.IS_XML, "setIsXml");
        table.put(WebTagNames.DEFERRED_SYNTAX_ALLOWED_AS_LITERAL, 
            "setDeferredSyntaxAllowedAsLiteral");
        table.put(WebTagNames.TRIM_DIRECTIVE_WHITESPACES, 
            "setTrimDirectiveWhitespaces");
        return table;
    }    
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node in the DOM tree 
     * @param node name for the root element of this xml fragment      
     * @param the descriptor to write
     * @return the DOM tree top node
     */
    public Node writeDescriptor(Node parent, String nodeName, JspGroupDescriptor descriptor) {  
        Node myNode = appendChild(parent, nodeName);

        LocalizedInfoNode localizedNode = new LocalizedInfoNode();
        writeLocalizedDescriptions(myNode, descriptor);        
        localizedNode.writeLocalizedMap(myNode, TagNames.NAME, descriptor.getLocalizedDisplayNames());
        
        // url-pattern*
        for (Enumeration urlPatterns = descriptor.getUrlPatterns(); urlPatterns.hasMoreElements();) {
            appendTextChild(myNode, WebTagNames.URL_PATTERN, (String) urlPatterns.nextElement());
        }
        appendTextChild(myNode, WebTagNames.EL_IGNORED, descriptor.getElIgnored());
        appendTextChild(myNode, WebTagNames.PAGE_ENCODING, descriptor.getPageEncoding());
        appendTextChild(myNode, WebTagNames.SCRIPTING_INVALID, descriptor.getScriptingInvalid());
        appendTextChild(myNode, WebTagNames.IS_XML, descriptor.getIsXml());
        // include-prelude*
        for (Enumeration includePreludes = descriptor.getIncludePreludes(); includePreludes.hasMoreElements();) {
            appendTextChild(myNode, WebTagNames.INCLUDE_PRELUDE, (String) includePreludes.nextElement());
        }
        // include-coda*
        for (Enumeration includeCodas = descriptor.getIncludeCodas(); includeCodas.hasMoreElements();) {
            appendTextChild(myNode, WebTagNames.INCLUDE_CODA, (String) includeCodas.nextElement());
        }
        appendTextChild(myNode, WebTagNames.DEFERRED_SYNTAX_ALLOWED_AS_LITERAL, descriptor.getDeferredSyntaxAllowedAsLiteral());
        appendTextChild(myNode, WebTagNames.TRIM_DIRECTIVE_WHITESPACES, descriptor.getTrimDirectiveWhitespaces());
        return myNode;
    }    
}
