/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * LoginConfigNode.java
 *
 * Created on March 5, 2002, 11:44 AM
 */

package com.sun.enterprise.deployment.node.web;

import java.util.Map;
import org.w3c.dom.Node;

import com.sun.enterprise.deployment.LoginConfigurationImpl;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.xml.WebTagNames;

/** 
 * This node handles the login-config xml tag
 *
 * @author  Jerome Dochez
 * @version 
 */
public class LoginConfigNode extends DeploymentDescriptorNode {

    /**
     * all sub-implementation of this class can use a dispatch table to map xml element to
     * method name on the descriptor class for setting the element value. 
     *  
     * @return the map with the element name as a key, the setter method as a value
     */    
    protected Map getDispatchTable() {    
        Map table = super.getDispatchTable();
        table.put(WebTagNames.AUTH_METHOD, "setAuthenticationMethod");
        table.put(WebTagNames.REALM_NAME, "setRealmName");                
        table.put(WebTagNames.FORM_LOGIN_PAGE, "setFormLoginPage");
        table.put(WebTagNames.FORM_ERROR_PAGE, "setFormErrorPage");                        
        return table;
    }
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node in the DOM tree 
     * @param node name for the root element of this xml fragment      
     * @param the descriptor to write
     * @return the DOM tree top node
     */
    public Node writeDescriptor(Node parent, String nodeName, LoginConfigurationImpl descriptor) {               
        Node myNode = appendChild(parent, nodeName);    
        appendTextChild(myNode, WebTagNames.AUTH_METHOD, descriptor.getAuthenticationMethod());
        appendTextChild(myNode, WebTagNames.REALM_NAME, descriptor.getRealmName());
        String loginPage = descriptor.getFormLoginPage();
        String errorPage =descriptor.getFormErrorPage();
        if (loginPage!=null && loginPage.length()>0 && errorPage !=null && errorPage.length()>0) {
            Node formNode = appendChild(myNode, WebTagNames.FORM_LOGIN_CONFIG);
            appendTextChild(formNode, WebTagNames.FORM_LOGIN_PAGE, loginPage);
            appendTextChild(formNode, WebTagNames.FORM_ERROR_PAGE, errorPage);
        }
        return myNode;
    }
}
