/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 *	This generated bean class ResourceAdapter matches the DTD element resource-adapter
 *
 *	Generated on Mon May 13 13:36:49 PDT 2002
 */

package com.sun.enterprise.deployment.runtime.connector;

import com.sun.enterprise.deployment.runtime.RuntimeDescriptor;
import com.sun.enterprise.deployment.NameValuePairDescriptor;

/**
 * This class was based on the schema2beans generated one modified
 * to remove its dependencies on schema2beans libraries.
 
 * @author  Jerome Dochez
 * @version 
 */
public class ResourceAdapter extends RuntimeDescriptor
{
    static public final String DESCRIPTION = "Description";	// NOI18N
    static public final String PROPERTY = "PropertyElement";	// NOI18N
    
    static public final String JNDI_NAME = "JndiName";
    static public final String MAX_POOL_SIZE = "MaxPoolSize";
    static public final String STEADY_POOL_SIZE = "SteadyPoolSize";
    static public final String MAX_WAIT_TIME_IN_MILLIS = "MaxWaitTimeInMillis";
    static public final String IDLE_TIMEOUT_IN_SECONDS = "IdleTimeoutInSeconds";
    
    // This attribute is an array, possibly empty
    public void setPropertyElement(int index, NameValuePairDescriptor value)
    {
	this.setValue(PROPERTY, index, value);
    }
    
    //
    public boolean isPropertyElement(int index)
    {
	NameValuePairDescriptor ret = (NameValuePairDescriptor)this.getValue(PROPERTY, index);
	return ret != null;
    }
    
    // This attribute is an array, possibly empty
    public void setPropertyElement(NameValuePairDescriptor[] values)
    {
	this.setValues(PROPERTY, values);
    }
    
    //
    public NameValuePairDescriptor[] getPropertyElement()
    {
	return (NameValuePairDescriptor[])this.getValues(PROPERTY);
    }
    
    // Return the number of properties
    public int sizePropertyElement()
    {
	return this.size(PROPERTY);
    }
    
    // Add a new element returning its index in the list
    public int addPropertyElement(NameValuePairDescriptor value)
    {
	return this.addValue(PROPERTY, value);
    }
    
    //
    // Remove an element using its reference
    // Returns the index the element had in the list
    //
    public int removePropertyElement(NameValuePairDescriptor value)
    {
	return this.removeValue(PROPERTY, value);
    }
    
    //
    // Remove an element using its index
    //
    public void removePropertyElement(int index)
    {
	this.removeValue(PROPERTY, index);
    }
    
    // This method verifies that the mandatory properties are set
    public boolean verify()
    {
	return true;
    }
}
