/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.runtime.web;

import java.beans.*;
import java.util.*;

import com.sun.enterprise.deployment.node.XMLElement;

import com.sun.enterprise.deployment.runtime.RuntimeDescriptor;
import com.sun.enterprise.deployment.runtime.common.EjbRef;
import com.sun.enterprise.deployment.runtime.common.ResourceEnvRef;
import com.sun.enterprise.deployment.runtime.common.ResourceRef;
import com.sun.enterprise.deployment.runtime.common.SecurityRoleMapping;

// BEGIN_NOI18N

public class SunWebApp extends WebPropertyContainer
{
    
    static public final String SECURITY_ROLE_MAPPING = "SecurityRoleMapping";	// NOI18N
    static public final String SERVLET = "Servlet";	// NOI18N
    static public final String SESSION_CONFIG = "SessionConfig";	// NOI18N
    static public final String RESOURCE_ENV_REF = "ResourceEnvRef";	// NOI18N
    static public final String RESOURCE_REF = "ResourceRef";	// NOI18N
    static public final String EJB_REF = "EjbRef";	// NOI18N
    static public final String CACHE = "Cache";	// NOI18N
    static public final String CLASS_LOADER = "ClassLoader";	// NOI18N
    static public final String JSP_CONFIG = "JspConfig";	// NOI18N
    static public final String LOCALE_CHARSET_INFO = "LocaleCharsetInfo";	// NOI18N
    static public final String PARAMETER_ENCODING = "ParameterEncoding";
    static public final String FORM_HINT_FIELD = "FormHintField";    
    static public final String DEFAULT_CHARSET = "DefaultCharset";
    public static final String IDEMPOTENT_URL_PATTERN = "IdempotentUrlPattern";
    public static final String ERROR_URL = "ErrorUrl";
    public static final String HTTPSERVLET_SECURITY_PROVIDER = "HttpServletSecurityProvider";

    
    public SunWebApp()
    {
	// set default values
	setAttributeValue(CACHE, "MaxEntries", "4096");
	setAttributeValue(CACHE, "TimeoutInSeconds", "30");
	setAttributeValue(CACHE, "Enabled", "false");
    }
    
    // This attribute is an array, possibly empty
    public void setSecurityRoleMapping(int index, SecurityRoleMapping value)
    {
	this.setValue(SECURITY_ROLE_MAPPING, index, value);
    }
    
    //
    public SecurityRoleMapping getSecurityRoleMapping(int index)
    {
	return (SecurityRoleMapping)this.getValue(SECURITY_ROLE_MAPPING, index);
    }
    
    // This attribute is an array, possibly empty
    public void setSecurityRoleMapping(SecurityRoleMapping[] value)
    {
	this.setValue(SECURITY_ROLE_MAPPING, value);
    }
    
    //
    public SecurityRoleMapping[] getSecurityRoleMapping()
    {
	return (SecurityRoleMapping[])this.getValues(SECURITY_ROLE_MAPPING);
    }
    
    // Return the number of properties
    public int sizeSecurityRoleMapping()
    {
	return this.size(SECURITY_ROLE_MAPPING);
    }
    
    // Add a new element returning its index in the list
    public int addSecurityRoleMapping(SecurityRoleMapping value)
    {
	return this.addValue(SECURITY_ROLE_MAPPING, value);
    }
    
    //
    // Remove an element using its reference
    // Returns the index the element had in the list
    //
    public int removeSecurityRoleMapping(SecurityRoleMapping value)
    {
	return this.removeValue(SECURITY_ROLE_MAPPING, value);
    }
    
    // This attribute is an array, possibly empty
    public void setServlet(int index, Servlet value)
    {
	this.setValue(SERVLET, index, value);
    }
    
    //
    public Servlet getServlet(int index)
    {
	return (Servlet)this.getValue(SERVLET, index);
    }
    
    // This attribute is an array, possibly empty
    public void setServlet(Servlet[] value)
    {
	this.setValue(SERVLET, value);
    }
    
    //
    public Servlet[] getServlet()
    {
	return (Servlet[])this.getValues(SERVLET);
    }
    
    // Return the number of properties
    public int sizeServlet()
    {
	return this.size(SERVLET);
    }
    
    // Add a new element returning its index in the list
    public int addServlet(Servlet value)
    {
	return this.addValue(SERVLET, value);
    }
    
    //
    // Remove an element using its reference
    // Returns the index the element had in the list
    //
    public int removeServlet(Servlet value)
    {
	return this.removeValue(SERVLET, value);
    }
    
    // This attribute is an array, possibly empty
    public void setIdempotentUrlPattern(int index, IdempotentUrlPattern value)
    {
        this.setValue(IDEMPOTENT_URL_PATTERN, index, value);
    }

    //
    public  IdempotentUrlPattern getIdempotentUrlPattern(int index)
    {
        return (IdempotentUrlPattern)this.getValue(IDEMPOTENT_URL_PATTERN, index);
    }

    // This attribute is an array, possibly empty
    public void setIdempotentUrlPatterns(IdempotentUrlPattern[] value)
    {
        this.setValue(IDEMPOTENT_URL_PATTERN, value);
    }

    //
    public IdempotentUrlPattern[] getIdempotentUrlPatterns()
    {
        return (IdempotentUrlPattern[])this.getValues(IDEMPOTENT_URL_PATTERN);
    }

    // Return the number of properties
    public int sizeIdempotentUrlPattern()
    {
        return this.size(IDEMPOTENT_URL_PATTERN);
    }

    // Add a new element returning its index in the list
    public int addIdempotentUrlPattern(IdempotentUrlPattern value)
    {
        return this.addValue(IDEMPOTENT_URL_PATTERN, value);
    }

    // Remove an element using its reference
    // Returns the index the element had in the list
    //
    public int removeIdempotentUrlPattern(IdempotentUrlPattern value)
    {
        return this.removeValue(IDEMPOTENT_URL_PATTERN, value);
    }

    // This attribute is optional
    public void setSessionConfig(SessionConfig value)
    {
	this.setValue(SESSION_CONFIG, value);
    }
    
    //
    public SessionConfig getSessionConfig()
    {
	return (SessionConfig)this.getValue(SESSION_CONFIG);
    }
    
    // This attribute is an array, possibly empty
    public void setResourceEnvRef(int index, ResourceEnvRef value)
    {
	this.setValue(RESOURCE_ENV_REF, index, value);
    }
    
    //
    public ResourceEnvRef getResourceEnvRef(int index)
    {
	return (ResourceEnvRef)this.getValue(RESOURCE_ENV_REF, index);
    }
    
    // This attribute is an array, possibly empty
    public void setResourceEnvRef(ResourceEnvRef[] value)
    {
	this.setValue(RESOURCE_ENV_REF, value);
    }
    
    //
    public ResourceEnvRef[] getResourceEnvRef()
    {
	return (ResourceEnvRef[])this.getValues(RESOURCE_ENV_REF);
    }
    
    // Return the number of properties
    public int sizeResourceEnvRef()
    {
	return this.size(RESOURCE_ENV_REF);
    }
    
    // Add a new element returning its index in the list
    public int addResourceEnvRef(ResourceEnvRef value)
    {
	return this.addValue(RESOURCE_ENV_REF, value);
    }
    
    //
    // Remove an element using its reference
    // Returns the index the element had in the list
    //
    public int removeResourceEnvRef(ResourceEnvRef value)
    {
	return this.removeValue(RESOURCE_ENV_REF, value);
    }
    
    // This attribute is an array, possibly empty
    public void setResourceRef(int index, ResourceRef value)
    {
	this.setValue(RESOURCE_REF, index, value);
    }
    
    //
    public ResourceRef getResourceRef(int index)
    {
	return (ResourceRef)this.getValue(RESOURCE_REF, index);
    }
    
    // This attribute is an array, possibly empty
    public void setResourceRef(ResourceRef[] value)
    {
	this.setValue(RESOURCE_REF, value);
    }
    
    //
    public ResourceRef[] getResourceRef()
    {
	return (ResourceRef[])this.getValues(RESOURCE_REF);
    }
    
    // Return the number of properties
    public int sizeResourceRef()
    {
	return this.size(RESOURCE_REF);
    }
    
    // Add a new element returning its index in the list
    public int addResourceRef(ResourceRef value)
    {
	return this.addValue(RESOURCE_REF, value);
    }
    
    //
    // Remove an element using its reference
    // Returns the index the element had in the list
    //
    public int removeResourceRef(ResourceRef value)
    {
	return this.removeValue(RESOURCE_REF, value);
    }
    
    // This attribute is an array, possibly empty
    public void setEjbRef(int index, EjbRef value)
    {
	this.setValue(EJB_REF, index, value);
    }
    
    //
    public EjbRef getEjbRef(int index)
    {
	return (EjbRef)this.getValue(EJB_REF, index);
    }
    
    // This attribute is an array, possibly empty
    public void setEjbRef(EjbRef[] value)
    {
	this.setValue(EJB_REF, value);
    }
    
    //
    public EjbRef[] getEjbRef()
    {
        // this is crazy
	return (EjbRef[])this.getValues(EJB_REF);
    }
    
    // Return the number of properties
    public int sizeEjbRef()
    {
	return this.size(EJB_REF);
    }
    
    // Add a new element returning its index in the list
    public int addEjbRef(EjbRef value)
    {
	return this.addValue(EJB_REF, value);
    }
    
    //
    // Remove an element using its reference
    // Returns the index the element had in the list
    //
    public int removeEjbRef(EjbRef value)
    {
	return this.removeValue(EJB_REF, value);
    }
    
    // This attribute is optional
    public void setCache(Cache value)
    {
	this.setValue(CACHE, value);
    }
    
    //
    public Cache getCache()
    {
	return (Cache)this.getValue(CACHE);
    }
    
    // This attribute is optional
    public void setClassLoader(ClassLoader value)
    {
        this.setValue(CLASS_LOADER, value);
    }

    //
    public ClassLoader getClassLoader()
    {
        return (ClassLoader)this.getValue(CLASS_LOADER);
    }

    
    // This attribute is optional
    public void setJspConfig(JspConfig value)
    {
	this.setValue(JSP_CONFIG, value);
    }
    
    //
    public JspConfig getJspConfig()
    {
	return (JspConfig)this.getValue(JSP_CONFIG);
    }
    
    // This attribute is optional
    public void setLocaleCharsetInfo(LocaleCharsetInfo value)
    {
	this.setValue(LOCALE_CHARSET_INFO, value);
    }
    
    //
    public LocaleCharsetInfo getLocaleCharsetInfo()
    {
	return (LocaleCharsetInfo)this.getValue(LOCALE_CHARSET_INFO);
    }
    
    // This method verifies that the mandatory properties are set
    public boolean verify()
    {
	return true;
    }

    // This attribute is optional
    public void setParameterEncoding(boolean value)
    {
        this.setValue(PARAMETER_ENCODING, new Boolean(value));
    }

    //
    public boolean isParameterEncoding()
    {
        Boolean ret = (Boolean)this.getValue(PARAMETER_ENCODING);
        if (ret == null) {
            return false;
        }
        return ret.booleanValue();
    }
}
