/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.types;

import java.util.Set;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;

/**
 * This type defines the behaviour of a J2EE Component containing 
 * message destination references.
 *
 * @author  Kennneth Saks
 * @version 
 */
public interface MessageDestinationReferenceContainer {
    
    /**
     * Add a message destination reference to myself
     * 
     * @param the new message destination ref
     */
    public void addMessageDestinationReferenceDescriptor(MessageDestinationReferenceDescriptor msgDestReference);
    
    /**
     * Return a message destination reference by the same name or throw an IllegalArgumentException.
     *
     * @param the message destination reference name
     */
    public MessageDestinationReferenceDescriptor getMessageDestinationReferenceByName(String name);
    
   /**
    * Return the set of message destination references declared.
    */
    public Set getMessageDestinationReferenceDescriptors();

    /**  
     * Removes the specified message destination reference from the receiver.
     *   
     * @param ref MessageDestinationReferenceDescriptor to remove.
     *
     */
    public void removeMessageDestinationReferenceDescriptor
        (MessageDestinationReferenceDescriptor msgDestRef);   
}

