/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.util;

import javax.enterprise.deploy.shared.ModuleType;

/**
 * Extended module types which are specific to SJSAS
 *
 * @author Sreenivas Munnangi
 */

public class XModuleType extends ModuleType {

    private static final int offset = 100;
    public static final XModuleType LCM = new XModuleType(100);
    public static final XModuleType CMB = new XModuleType(101);

    private static final String[] stringTable = {
        "lcm",
        "cmb"
    };

    private static final XModuleType[] enumValueTable = {
        LCM,
        CMB
    };

    private static final String[] moduleExtension = {
        ".jar",
        ".jar"
    };

    protected XModuleType(int value) {
        super(value);
    }

    protected String[] getStringTable() {
        return this.stringTable;
    }

    protected ModuleType[] getEnumValueTable() {
        return this.enumValueTable;
    }

    public String getModuleExtension() {
        if (super.getValue() >= this.getOffset()) {
            return (this.moduleExtension[super.getValue() - this.getOffset()]);
        } else {
            return super.getModuleExtension();
        }
    }

    public static ModuleType getModuleType(int value) {
        if (value >= offset) {
            return enumValueTable[value-offset];
        } else {
            return ModuleType.getModuleType(value);
        }
    }

    public String toString() {
        String[] strTable = this.getStringTable();
        int index = super.getValue() - this.getOffset();
        if (strTable != null && index >= 0 && index < strTable.length)
            return strTable[index];
        else
            super.toString();
        return null;
    }

    protected int getOffset() {
        return offset; 
    }

}
