/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.web;

import java.util.Enumeration;

/**
 * This is the descriptor for the authorization constraint element in
 * the DTD.
 * @author Danny Coward
 */

public interface AuthorizationConstraint extends WebDescriptor {
    public static String BASIC_METHOD = "basic";
    public static String FORM_METHOD = "form";
    public static String MUTUAL_METHOD = "mutual";

    /** 
     * Return the security roles involved in this constraint. 
     * @return the enumeration of security roles.
     */
    public Enumeration getSecurityRoles();

    /**
     * Add a security role to the constraint.
     * @param the security role.
     */
    public void addSecurityRole(SecurityRole securityRole);
}
