/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.util;

import java.rmi.RemoteException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import java.util.Hashtable;
import com.sun.enterprise.log.Log;

//START OF IASRI 4660742
import java.util.logging.*;
import com.sun.logging.*;
//END OF IASRI 4660742


/**
 *
 * @author Kenneth Saks
 */
class SimpleUniqueValueGenerator implements UniqueValueGenerator {

    // START OF IASRI 4660742
    static Logger _logger=LogDomains.getLogger(LogDomains.UTIL_LOGGER);
    // END OF IASRI 4660742

    // Map context name to value block.
    private static Hashtable contextBlocks_;

    // Remote object that provides the unique number service.
    private static UniqueValueGeneratorBackend generatorBackend_;

    // Id of remote generator that is guaranteed to be unique
    // across invocations of a single j2ee server.
    private static String generatorBackendId_;

    // Namespace within which unique values will be generated.
    private String context_;

    static {
        generatorBackendId_ = null;
        generatorBackend_   = null;
        contextBlocks_      = new Hashtable();
    }

    /**
     * Use package-level access since clients should use a
     * UniqueValueGeneratorFactory to create concrete instances
     * this class.
     */
    SimpleUniqueValueGenerator(String context) {
        context_    = context;
    }

    private static synchronized 
        UniqueValueGeneratorBackend getBackendGenerator() 
        throws Exception {
        if( generatorBackend_ == null ) {
            InitialContext jndiContext = new InitialContext();
            generatorBackend_   = (UniqueValueGeneratorBackend) 
                jndiContext.lookup(UniqueValueGeneratorBackend.JNDI_NAME);
        }
        return generatorBackend_;
    }

    private static synchronized String getGeneratorBackendId() 
        throws UniqueValueGeneratorException {
        if( generatorBackendId_ == null ) {
            try {
                UniqueValueGeneratorBackend backend = getBackendGenerator();
                generatorBackendId_ = backend.getGeneratorId();
            } catch(Exception e) {
                /** IASRI 4660742
                Log.err.println(e); 
                **/
		            // START OF IASRI 4660742
                _logger.log(Level.SEVERE,"enterprise_util.excep_suidgen_getgenbackendid",e);
                // END OF IASRI 4660742

                throw new UniqueValueGeneratorException(e.getMessage());
            }
        }        
        return generatorBackendId_;
    }

    private static synchronized long nextNumberInternal(String context) 
        throws UniqueValueGeneratorException {

        UniqueValueBlock valueBlock = null;
        try {
            UniqueValueGeneratorBackend generatorBackend = 
                getBackendGenerator();

            valueBlock = (UniqueValueBlock) contextBlocks_.get(context);
            
            if( (valueBlock == null) || (!valueBlock.hasNext()) ) {
                valueBlock = generatorBackend.getNextValueBlock(context);
                contextBlocks_.put(context, valueBlock);
            }
        } catch(Exception e) {
            /** IASRI 4660742
            Log.err.println(e); 
            **/
	          // START OF IASRI 4660742
            _logger.log(Level.SEVERE,"enterprise_util.excep_suidgen_nextnuminternal",e);
            // END OF IASRI 4660742
            throw new UniqueValueGeneratorException(e.getMessage());
        }
        
        return valueBlock.next();
    }

    public long nextNumber() throws UniqueValueGeneratorException {
        return nextNumberInternal(getContext());
    }
    
    public String nextId() throws UniqueValueGeneratorException {
        return getGeneratorBackendId() + "_" + nextNumber();
    }

    public String getContext() {
        return context_;
    }
    
}
