/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.util;

import java.rmi.Remote;
import java.rmi.RemoteException;

/**
 * Interface for server-side implementation of unique value
 * generator.  NOTE : This is not intended to be used by clients
 * that need unique numbers.  It is only used internally
 * by concrete UniqueValueGenerator implementations.  Clients should
 * use UniqueValueGeneratorFactory and UniqueValueGenerator instead.
 *
 * @author Kenneth Saks
 */
public interface UniqueValueGeneratorBackend extends Remote {

    // Name under which server side object is registered
    String JNDI_NAME = "J2EE_UNIQUE_VALUE_GEN";

    /**
     * Id generated by backend upon startup that will be unique
     * for each successive invocation of the same j2ee server instance.
     */
    String getGeneratorId() throws RemoteException;
    
    /**
     * Get another block of unique numbers for a particular context.
     */
    UniqueValueBlock getNextValueBlock(String context) throws RemoteException;


}
