/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * @version 1.00 April 1, 2000
 * @author Byron Nevins
 */

package com.sun.enterprise.util.io;

import java.io.*;
//import java.util.*;
//import java.util.jar.*;
//import java.util.zip.*;


public class Tee extends PrintStream 
{

	/////////////////////////////////////////////////////////////////

	private Tee(PrintStream ps) 
	{
		super(ps);
	}


	/////////////////////////////////////////////////////////////////

	// Starts copying stdout and 
	//stderr to the file f.
	public static void start(String f) throws IOException 
	{
		// Save old settings.
		oldStdout = System.out;
		oldStderr = System.err;

		// Create/Open logfile.
		logfile = new PrintStream(new BufferedOutputStream(new FileOutputStream(f)));

		// Start redirecting the output.
		System.setOut(new Tee(System.out));
		System.setErr(new Tee(System.err));
	}


	/////////////////////////////////////////////////////////////////

	// Restores the original settings.
	public static void stop() 
	{
		System.setOut(oldStdout);
		System.setErr(oldStderr);
		
		try 
		{
			logfile.close();
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
		}
	}


	/////////////////////////////////////////////////////////////////

	// PrintStream override.
	public void write(int b) 
	{
		try 
		{
			logfile.write(b);
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			setError();
		}
		super.write(b);
	}

	/////////////////////////////////////////////////////////////////

	// PrintStream override.
	public void write(byte buf[], int off, int len) 
	{
		try 
		{
			logfile.write(buf, off, len);
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			setError();
		}
		super.write(buf, off, len);
	}

	/////////////////////////////////////////////////////////////////

	static OutputStream logfile;
	static PrintStream oldStdout;
	static PrintStream oldStderr;

	/////////////////////////////////////////////////////////////////

	public static void main(String[] args) 
	{
		try 
		{
			// Start capturing characters 
			//into the log file.
			Tee.start("log.txt");

			// Test it.
			System.out.println(
			"Here's is some stuff to stdout.");
			System.err.println(
			"Here's is some stuff to stderr.");
			System.out.println(
			"Let's throw an exception...");
			new Exception().printStackTrace();
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
		} 
		finally 
		{
			// Stop capturing characters 
			//into the log file 
			// and restore old setup.
			Tee.stop();
		}
	}
}
