/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package org.apache.tools.ant.taskdefs.optional.sun.appserv;

import org.apache.tools.ant.Task;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.types.Path;

import java.io.*;
import java.util.*;

/**
	SunONEInput is used to get Inputs from the Users.
    Inspired by Ant 1.5 input task.  
    This task is very useful to get inputs from the users.
	This will get deprecated when we move to Ant 1.5
*/

public class SunONEInput extends Task {

         private String msg;
         private String value;
         private String addproperty;

         private BufferedReader keyboard;

         LocalStringsManager lsm = new LocalStringsManager();

	 public void init ()
	 {
	     keyboard = new BufferedReader(new InputStreamReader(System.in));
	 }
         // The method executing the task
         public void execute() throws BuildException {

	    try{

            System.out.println( msg);
	    value  = keyboard.readLine();
	    }
	    catch ( IOException ioe )
	    {
               System.out.println(lsm.getString("IOExceptionMsg", new Object[] {msg})); 
	    }
            if (addproperty != null) {
              project.setProperty(addproperty, value);
            }
         }

         // The setter for the "message" attribute

         public void setMessage(String msg) {
             this.msg = msg;
         }


    public void setAddproperty (String addproperty) {
        this.addproperty = addproperty;
    }


} //end of SunONEInput
