/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.ejb;

import java.rmi.RemoteException;

/**
 * ReadOnlyBeanNotifier is used to force refresh of ReadOnly beans
 *
 * @author Mahesh Kannan
 */

public interface ReadOnlyBeanNotifier
    extends java.rmi.Remote
{

    /**
     * This method would be used by the user to manually force the 
     *  refresh of read only beans for an application. After this method
     *  the next access to the bean, identified by the primary key, will
     *  cause a ejbLoad() to be called on the bean
     *
     * @param The primary of the bean to be refreshed
     */
    public void refresh(Object primaryKey)
        throws RemoteException;

    /**
     * This method forces *all* primary keys for a read-only bean 
     * to be marked as needing a refresh.  
     */
    public void refreshAll()
        throws RemoteException;
}
