/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * PROPRIETARY/CONFIDENTIAL.  Use of this product is subject to license terms.
 *
 * Copyright 2000-2001 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 */

package com.sun.appserv.server;


/**
 * This class defines the types of events that get fired by the application server. 
 * It also contains a LifecycleEventContext that can be used by the 
 * lifecycle modules.
 */
public class LifecycleEvent extends java.util.EventObject {
    
    private int eventType;
    private Object eventData;
    private LifecycleEventContext ctx = null;
    
    // Lifecycle event types 

    /** Server is initializing subsystems and setting up the runtime environment.
    */
    public final static int INIT_EVENT = 0; 

    /** Server is starting up applications
     */
    public final static int STARTUP_EVENT = 1; 

    /** Server is ready to service requests
     */
    public final static int READY_EVENT = 2; 

    /** Server is shutting down applications
     */
    public final static int SHUTDOWN_EVENT = 3; 

    /** Server is terminating the subsystems and the runtime environment.
     */
    public final static int TERMINATION_EVENT = 4; 

    
    /**
     * Construct new lifecycle event
     * @param source The object on which the event initially occurred
     * @param eventType type of the event
     * @param ctx the underlying context for the lifecycle event
     */
    public LifecycleEvent(Object source, int eventType, Object eventData, LifecycleEventContext ctx) {
        super(source);

        this.eventType = eventType;
        this.eventData = eventData;
        this.ctx = ctx;
    }
    
    /** Get the type of event associated with this 
     */
    public int getEventType() {
        return eventType;
    }

    /** Get the data associated with the event.
     */
    public Object getData() {
        return eventData;
    }

    /** Get the ServerContext generating this lifecycle event 
     */
    public LifecycleEventContext getLifecycleEventContext() {
        return ctx;
    }
}
