/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * PROPRIETARY/CONFIDENTIAL.  Use of this product is subject to license terms.
 *
 * Copyright 2000-2001 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 */

package com.sun.appserv.server;

import java.util.Properties;

/**
 * lifecycle modules implement <code>com.sun.appserv.server.LifecycleListener</code> interface. 
 * There is just one method in this interface: <code>handleEvent()</code> which posts server
 * lifecycle events to the lifecycle modules.
 * <p>
 * Upon start up, before initializing its subsystems application server posts lifcycle modules the 
 * <code>INIT_EVENT</code>. This is followed by server posting the <code>STARTUP_EVENT</code> to the 
 * lifecycle modules upon which server starts loading and initializaing the applications. Once this 
 * phase is completed, the <code>READY_EVENT</code> is posted to the lifecycle modules.
 * <p>
 * When the server is shutdown, server posts the <code>SHUTDOWN_EVENT</code> to the lifecycle modules and
 * then shuts down the applications and subsystems. Once this phase is completed the 
 * <code>TERMINATION_EVENT</code> is posted.
 * <p>
 * Note that lifecycle modules may obtain the event specific data by calling <code>getData()</code> 
 * on the event parameter in the <code>handleEvent()</code>. For the INIT_EVENT event,
 * <code>getData()</code> returns the lifecycle module's properties configured in server.xml.
 * <p>
 *  When <code>is-failure-fatal</code> in server.xml is set to <code>true</code>, all exceptions from the
 *  lifecycle modules are treated as fatal conditions.
 */
public interface LifecycleListener {

    /** receive a server lifecycle event 
     *  @param event associated event
     *  @throws <code> ServerLifecycleException </code> for exception condition.
     *
     */
    public void handleEvent(LifecycleEvent event) throws ServerLifecycleException; 
}
