/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.base.io;

import java.io.*;
import java.security.*;
import java.rmi.*;
import javax.ejb.*;
import javax.naming.*;

import java.util.logging.*;
import com.sun.logging.*;

import com.sun.ejb.spi.io.J2EEObjectStreamFactory;
import com.sun.ejb.spi.io.NonSerializableObjectHandler;

/**
 * A Factory class for creating EJBObject input/output Stream
 *
 * @author Mahesh Kannan
 */
public class J2EEObjectStreamFactoryImpl
    implements J2EEObjectStreamFactory
{

    private static Logger _ejbLogger =
       LogDomains.getLogger(LogDomains.EJB_LOGGER);

    public J2EEObjectStreamFactoryImpl() {
    }

    /**
     *
     * Obtain an ObjectOutputStream that allows serialization
     *  of a graph of objects. The objects can be plain Serializable objects
     *  or can be converted into Serializable objects using
     *  the handler
     *
     *@throws IOException when the serialziation fails
     *@return an ObjectOutputStream that can be used to serialize objects
     */
    public ObjectOutputStream createObjectOutputStream(
            final OutputStream os,
            final boolean replaceObject,
            final NonSerializableObjectHandler handler)
        throws IOException
    {
        // Need privileged block here because EJBObjectOutputStream
        // does enableReplaceObject
        ObjectOutputStream oos = null;
        try {
            oos = (ObjectOutputStream)AccessController.doPrivileged(
                new PrivilegedExceptionAction() {
                    public java.lang.Object run() 
                        throws Exception
                    {
                        return new EJBObjectOutputStream(
                            os, replaceObject, handler);
                    }
                });
        } catch ( PrivilegedActionException ex ) {
            throw (IOException) ex.getException();
        }
        return oos; 
    }

    /**
     *
     * Obtain an ObjectInputStream that allows de-serialization
     *  of a graph of objects.
     *
     *@throws IOException when the de-serialziation fails
     *@return an ObjectInputStream that can be used to deserialize objects
     */
	public ObjectInputStream createObjectInputStream(
            final InputStream is,
            final boolean resolveObject,
            final ClassLoader loader)
        throws Exception
    {
        ObjectInputStream ois = null;
        if ( loader != null ) {
            // Need privileged block here because EJBObjectInputStream
            // does enableResolveObject
            try {
                ois = (ObjectInputStream)AccessController.doPrivileged(
                new PrivilegedExceptionAction() {
                    public java.lang.Object run()
                        throws Exception
                    {
                        return new EJBObjectInputStream(
                            is, loader, resolveObject);
                    }
                });
            } catch ( PrivilegedActionException ex ) {
                throw (IOException) ex.getException();
            }
        } else {
            ois = new ObjectInputStream(is);
        }

        return ois;
    }

}
